/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.vis.jfree;

import java.awt.Color;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.jfree.chart.ChartColor;

public enum ColorManager {
    RED(new Color(255, 85, 85)),
    BLUE(new Color(85, 85, 255)),
    GREEN(new Color(85, 255, 85)),
    YELLOW(new Color(255, 255, 85)),
    MAGENTA(new Color(255, 85, 255)),
    CYAN(new Color(85, 255, 255)),
    PINK(Color.PINK),
    DARK_RED(ChartColor.DARK_RED),
    DARK_BLUE(ChartColor.DARK_BLUE),
    DARK_GREEN(ChartColor.DARK_GREEN),
    DARK_YELLOW(ChartColor.DARK_YELLOW),
    DARK_MAGENTA(ChartColor.DARK_MAGENTA),
    DARK_CYAN(ChartColor.DARK_CYAN),
    LIGHT_RED(ChartColor.LIGHT_RED),
    LIGHT_BLUE(ChartColor.LIGHT_BLUE),
    LIGHT_GREEN(ChartColor.LIGHT_GREEN),
    LIGHT_YELLOW(ChartColor.LIGHT_YELLOW),
    LIGHT_MAGENTA(ChartColor.LIGHT_MAGENTA),
    LIGHT_CYAN(ChartColor.LIGHT_CYAN),
    VERY_DARK_RED(ChartColor.VERY_DARK_RED),
    VERY_DARK_BLUE(ChartColor.VERY_DARK_BLUE),
    VERY_DARK_GREEN(ChartColor.VERY_DARK_GREEN),
    VERY_DARK_YELLOW(ChartColor.VERY_DARK_YELLOW),
    VERY_DARK_MAGENTA(ChartColor.VERY_DARK_MAGENTA),
    VERY_DARK_CYAN(ChartColor.VERY_DARK_CYAN),
    VERY_LIGHT_RED(ChartColor.VERY_LIGHT_RED),
    VERY_LIGHT_BLUE(ChartColor.VERY_LIGHT_BLUE),
    VERY_LIGHT_GREEN(ChartColor.VERY_LIGHT_GREEN),
    VERY_LIGHT_YELLOW(ChartColor.VERY_LIGHT_YELLOW),
    VERY_LIGHT_MAGENTA(ChartColor.VERY_LIGHT_MAGENTA),
    VERY_LIGHT_CYAN(ChartColor.VERY_LIGHT_CYAN),
    TURQUOISE(new Color(64, 224, 208)),
    ORANGE(new Color(255, 165, 0)),
    SIENNA(new Color(160, 82, 45)),
    PURPLE(new Color(128, 0, 128)),
    SAND(new Color(255, 192, 112)),
    DARK_GRAY(Color.DARK_GRAY),
    RED_SHADE_00(new Color(105, 105, 130)),
    RED_SHADE_01(new Color(120, 95, 117)),
    RED_SHADE_02(new Color(135, 85, 104)),
    RED_SHADE_03(new Color(150, 75, 91)),
    RED_SHADE_04(new Color(165, 65, 78)),
    RED_SHADE_05(new Color(180, 55, 65)),
    RED_SHADE_06(new Color(195, 45, 52)),
    RED_SHADE_07(new Color(210, 35, 39)),
    RED_SHADE_08(new Color(225, 25, 26)),
    RED_SHADE_09(new Color(240, 15, 13)),
    RED_SHADE_10(new Color(255, 5, 0)),
    HALF_BLUE(ChartColor.LIGHT_BLUE),
    RED_PURE(Color.RED),
    LIGHT_GRAY(Color.LIGHT_GRAY),
    GRAY(Color.GRAY),
    BLACK(Color.BLACK),
    WHITE(Color.WHITE);

    public static final String COLOR_ATTRIBUTE = "color";
    public static final ColorManager NON_HIGHLIGHT;
    private static final int NUM_AUTOMATIC_COLORS;
    private final Color color;

    static {
        NON_HIGHLIGHT = RED_SHADE_00;
        NUM_AUTOMATIC_COLORS = DARK_GRAY.ordinal() + 1;
    }

    private ColorManager(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public static ColorManager getAutomaticColor(String colorKey) {
        return ColorManager.getAutomaticColor(colorKey.hashCode());
    }

    public static ColorManager getAutomaticColor(int colorIndex) {
        return ColorManager.values()[Math.abs(colorIndex) % NUM_AUTOMATIC_COLORS];
    }

    public static ColorManager getShadeOfRed(float weight) {
        int offset = Math.round(weight * 10.0f);
        if (offset < 0) {
            offset = 0;
        }
        if (offset > 10) {
            offset = 10;
        }
        return ColorManager.values()[RED_SHADE_00.ordinal() + offset];
    }

    public static ColorManager getColor(IAttributeAware iaa) {
        return ColorManager.getColor(iaa, null);
    }

    public static ColorManager getColor(IAttributeAware iaa, ColorManager defaultColor) {
        String color = iaa.getAttributeValue(COLOR_ATTRIBUTE);
        if (color == null) {
            return defaultColor;
        }
        try {
            return Enum.valueOf(ColorManager.class, color.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return defaultColor;
        }
    }
}

