/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.viewers;

import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.ChartPanelSelectionHandler;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.ChartPanelViewer;
import org.eclipse.trace4cps.common.jfreechart.ui.widgets.ChartPanelComposite;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.util.Args;

public abstract class ChartPanelContentViewer
extends ContentViewer
implements ChartPanelViewer {
    private final Composite parentComposite;
    private ISelection selection = StructuredSelection.EMPTY;
    private boolean preserveSelection = false;
    private ChartPanelControlTuple controlTuple = null;

    public ChartPanelContentViewer(Composite parent) {
        this.parentComposite = parent;
    }

    @Override
    public Control getControl() {
        return this.getControlTuple().getControl();
    }

    @Override
    public ChartPanelComposite getChartPanelComposite() {
        return this.getControlTuple().getChartPanelComposite();
    }

    @Override
    public ChartPanelSelectionHandler getChartPanelSelectionHandler() {
        return this.getControlTuple().getChartPanelSelectionHandler();
    }

    private ChartPanelControlTuple getControlTuple() {
        if (this.controlTuple == null) {
            this.controlTuple = this.createControl(this.parentComposite, 768, ChartPanelSelectionHandler.SelectionType.Multi);
            this.configureChartPanel();
        }
        return this.controlTuple;
    }

    protected ChartPanelControlTuple createControl(Composite parent, int style, ChartPanelSelectionHandler.SelectionType selectionType) {
        ChartPanelComposite composite = new ChartPanelComposite(parent, style);
        ChartPanelSelectionHandler selectionHandler = new ChartPanelSelectionHandler(composite.getChartPanel(), (ISelectionProvider)this, selectionType);
        return new ChartPanelControlTuple((Control)composite, composite, selectionHandler);
    }

    protected void configureChartPanel() {
    }

    protected boolean isPreserveSelection() {
        return this.preserveSelection;
    }

    protected void setPreserveSelection(boolean preserveSelection) {
        this.preserveSelection = preserveSelection;
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.internalRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void internalRefresh() {
        JFreeChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        this.getChartPanelComposite().setNotify(false);
        try {
            StructuredSelection selection = StructuredSelection.EMPTY;
            if (this.preserveSelection) {
                selection = this.getSelection();
            }
            JFreeChart jFreeChart = chart;
            synchronized (jFreeChart) {
                this.refreshChart();
            }
            this.setSelection((ISelection)selection);
        }
        finally {
            this.getChartPanelComposite().setNotify(true);
        }
    }

    protected abstract void refreshChart();

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.selection = selection;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
    }

    protected final class ChartPanelControlTuple {
        private final Control control;
        private final ChartPanelComposite chartPanelComposite;
        private final ChartPanelSelectionHandler chartPanelSelectionHandler;

        public ChartPanelControlTuple(Control control, ChartPanelComposite chartPanelComposite, ChartPanelSelectionHandler chartPanelSelectionHandler) {
            Args.nullNotPermitted((Object)control, (String)"control");
            Args.nullNotPermitted((Object)((Object)chartPanelComposite), (String)"chartPanelComposite");
            Args.nullNotPermitted((Object)chartPanelSelectionHandler, (String)"chartPanelSelectionHandler");
            this.control = control;
            this.chartPanelComposite = chartPanelComposite;
            this.chartPanelSelectionHandler = chartPanelSelectionHandler;
        }

        public Control getControl() {
            return this.control;
        }

        public ChartPanelComposite getChartPanelComposite() {
            return this.chartPanelComposite;
        }

        public ChartPanelSelectionHandler getChartPanelSelectionHandler() {
            return this.chartPanelSelectionHandler;
        }

        public ChartPanelControlTuple wrapControl(Control control) {
            return new ChartPanelControlTuple(control, this.chartPanelComposite, this.chartPanelSelectionHandler);
        }
    }
}

