/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.dist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.trace4cps.analysis.constraintgraph.ConstraintConfig;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.Constraint;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.ConstraintGraph;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.ConstraintGraphNode;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.EventNode;
import org.eclipse.trace4cps.analysis.dist.DistanceResult;
import org.eclipse.trace4cps.analysis.dist.Representation;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.ITrace;

public final class DistanceAnalysis {
    private DistanceAnalysis() {
    }

    public static long distance(ITrace e1, ITrace e2, Representation r) {
        ConstraintConfig cfg = ConstraintConfig.getDefault();
        cfg.setApplyOrderingHeuristic(Double.POSITIVE_INFINITY);
        ConstraintGraph g1 = new ConstraintGraph(e1, cfg);
        ConstraintGraph g2 = new ConstraintGraph(e2, cfg);
        return DistanceAnalysis.distance(g1, g2, r);
    }

    public static long distance(List<IEvent> e1, List<IEvent> e2, Representation r) {
        ConstraintConfig cfg = ConstraintConfig.getDefault();
        cfg.setApplyOrderingHeuristic(Double.POSITIVE_INFINITY);
        ConstraintGraph g1 = new ConstraintGraph(e1, cfg);
        ConstraintGraph g2 = new ConstraintGraph(e2, cfg);
        return DistanceAnalysis.distance(g1, g2, r);
    }

    private static long distance(ConstraintGraph cg1, ConstraintGraph cg2, Representation r) {
        long distance = 0L;
        Set<VertexClaimWrapper> v1 = DistanceAnalysis.getVerticesAsSet(cg1, r);
        Set<VertexClaimWrapper> v2 = DistanceAnalysis.getVerticesAsSet(cg2, r);
        Set<VertexClaimWrapper> symdif1 = DistanceAnalysis.computeSymDif(v1, v2);
        distance += (long)symdif1.size();
        Set<EdgeClaimWrapper> e1 = DistanceAnalysis.getEdges(cg1, r);
        Set<EdgeClaimWrapper> e2 = DistanceAnalysis.getEdges(cg2, r);
        Set<EdgeClaimWrapper> symdif2 = DistanceAnalysis.computeSymDif(e1, e2);
        return distance += (long)symdif2.size();
    }

    public static DistanceResult distance(ITrace e1, ITrace e2, Representation r, boolean annotateReference) {
        ConstraintConfig cfg = ConstraintConfig.getDefault();
        cfg.setApplyOrderingHeuristic(Double.POSITIVE_INFINITY);
        ConstraintGraph g1 = new ConstraintGraph(e1, cfg);
        ConstraintGraph g2 = new ConstraintGraph(e2, cfg);
        return DistanceAnalysis.run(g1, g2, r, annotateReference);
    }

    private static DistanceResult run(ConstraintGraph g1, ConstraintGraph g2, Representation r, boolean annotateReference) {
        long distance = 0L;
        HashMap<IEvent, InterestWrapper> interestCount = new HashMap<IEvent, InterestWrapper>();
        Map<String, VertexClaimWrapper> v1 = DistanceAnalysis.getVertices(g1, r);
        Map<String, VertexClaimWrapper> v2 = DistanceAnalysis.getVertices(g2, r);
        Set<VertexClaimWrapper> v1minv2 = DistanceAnalysis.computeSetMinus(v1.values(), v2.values());
        Set<VertexClaimWrapper> v2minv1 = DistanceAnalysis.computeSetMinus(v2.values(), v1.values());
        distance += (long)(v1minv2.size() + v2minv1.size());
        if (annotateReference) {
            for (VertexClaimWrapper v : v1minv2) {
                interestCount.put(v.node.getEvent(), new InterestWrapper(v.node.getEvent()));
            }
        }
        for (VertexClaimWrapper v : v2minv1) {
            interestCount.put(v.node.getEvent(), new InterestWrapper(v.node.getEvent()));
        }
        Set<EdgeClaimWrapper> e1 = DistanceAnalysis.getEdges(g1, r);
        Set<EdgeClaimWrapper> e2 = DistanceAnalysis.getEdges(g2, r);
        Set<EdgeClaimWrapper> e1mine2 = DistanceAnalysis.computeSetMinus(e1, e2);
        Set<EdgeClaimWrapper> e2mine1 = DistanceAnalysis.computeSetMinus(e2, e1);
        distance += (long)(e1mine2.size() + e2mine1.size());
        DistanceAnalysis.annotateEdges(interestCount, annotateReference, true, e1mine2, v2);
        DistanceAnalysis.annotateEdges(interestCount, true, annotateReference, e2mine1, v1);
        HashMap<Integer, List<IEvent>> ic = new HashMap<Integer, List<IEvent>>();
        for (InterestWrapper w : interestCount.values()) {
            ArrayList<IEvent> list = (ArrayList<IEvent>)ic.get(w.cnt);
            if (list == null) {
                list = new ArrayList<IEvent>();
                ic.put(w.cnt, list);
            }
            list.add(w.event);
        }
        return new DistanceResult(distance, ic);
    }

    private static void annotateEdges(Map<IEvent, InterestWrapper> interestCount, boolean annotateV1, boolean annotateV2, Set<EdgeClaimWrapper> e1mine2, Map<String, VertexClaimWrapper> v2) {
        for (EdgeClaimWrapper e : e1mine2) {
            if (annotateV1) {
                DistanceAnalysis.increment(e.getSrc(), interestCount);
                DistanceAnalysis.increment(e.getDst(), interestCount);
            }
            if (!annotateV2) continue;
            VertexClaimWrapper w = v2.get(e.srcRep);
            if (w != null) {
                DistanceAnalysis.increment(w.node.getEvent(), interestCount);
            }
            if ((w = v2.get(e.dstRep)) == null) continue;
            DistanceAnalysis.increment(w.node.getEvent(), interestCount);
        }
    }

    private static void increment(IEvent t, Map<IEvent, InterestWrapper> interestCount) {
        InterestWrapper w = interestCount.get(t);
        if (w == null) {
            interestCount.put(t, new InterestWrapper(t));
        } else {
            w.increment();
        }
    }

    private static Map<String, VertexClaimWrapper> getVertices(ConstraintGraph g, Representation repr) {
        HashMap<String, VertexClaimWrapper> r = new HashMap<String, VertexClaimWrapper>();
        int dup = 1;
        for (ConstraintGraphNode n : g.getNodes()) {
            VertexClaimWrapper w = new VertexClaimWrapper((EventNode)n, repr);
            if (r.containsKey(w.representation)) {
                w = new VertexClaimWrapper((EventNode)n, repr, dup);
                ++dup;
            }
            r.put(w.representation, w);
        }
        return r;
    }

    private static Set<VertexClaimWrapper> getVerticesAsSet(ConstraintGraph g, Representation repr) {
        HashSet<VertexClaimWrapper> r = new HashSet<VertexClaimWrapper>();
        for (ConstraintGraphNode n : g.getNodes()) {
            r.add(new VertexClaimWrapper((EventNode)n, repr));
        }
        return r;
    }

    private static Set<EdgeClaimWrapper> getEdges(ConstraintGraph g, Representation repr) {
        HashSet<EdgeClaimWrapper> r = new HashSet<EdgeClaimWrapper>();
        for (ConstraintGraphNode e : g.getNodes()) {
            for (Constraint c : e.constraints()) {
                r.add(new EdgeClaimWrapper(c, repr));
            }
        }
        return r;
    }

    private static <T> Set<T> computeSymDif(Set<T> s1, Set<T> s2) {
        HashSet<T> result = new HashSet<T>();
        for (T o1 : s1) {
            if (s2.contains(o1)) continue;
            result.add(o1);
        }
        for (T o2 : s2) {
            if (s1.contains(o2)) continue;
            result.add(o2);
        }
        return result;
    }

    private static <T> Set<T> computeSetMinus(Collection<T> s1, Collection<T> s2) {
        HashSet<T> result = new HashSet<T>();
        for (T o1 : s1) {
            if (s2.contains(o1)) continue;
            result.add(o1);
        }
        return result;
    }

    private static final class EdgeClaimWrapper {
        private final String representation;
        private final EventNode src;
        private final EventNode dst;
        private final String srcRep;
        private final String dstRep;

        private EdgeClaimWrapper(Constraint c, Representation r) {
            this.src = (EventNode)c.getSrc();
            this.dst = (EventNode)c.getDst();
            this.srcRep = r.represent(this.src.getEvent());
            this.dstRep = r.represent(this.dst.getEvent());
            StringBuilder b = new StringBuilder();
            b.append(this.srcRep).append("->").append(this.dstRep);
            this.representation = b.toString();
        }

        private IEvent getSrc() {
            return this.src.getEvent();
        }

        private IEvent getDst() {
            return this.dst.getEvent();
        }

        public int hashCode() {
            return this.representation == null ? 0 : this.representation.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EdgeClaimWrapper other = (EdgeClaimWrapper)obj;
            return !(this.representation == null ? other.representation != null : !this.representation.equals(other.representation));
        }

        public String toString() {
            return this.representation;
        }
    }

    private static final class InterestWrapper {
        private int cnt;
        private final IEvent event;

        public InterestWrapper(IEvent e) {
            this.event = e;
            this.cnt = 1;
        }

        public void increment() {
            ++this.cnt;
        }
    }

    private static final class VertexClaimWrapper {
        private final String representation;
        private final EventNode node;

        private VertexClaimWrapper(EventNode c, Representation r) {
            this.node = c;
            this.representation = r.represent(c.getEvent());
        }

        private VertexClaimWrapper(EventNode c, Representation r, int dup) {
            this.node = c;
            this.representation = r.represent(c.getEvent()) + ";dup=" + dup;
        }

        public int hashCode() {
            return this.representation == null ? 0 : this.representation.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VertexClaimWrapper other = (VertexClaimWrapper)obj;
            return !(this.representation == null ? other.representation != null : !this.representation.equals(other.representation));
        }

        public String toString() {
            return "VertexClaimWrapper [representation=" + this.representation + "]";
        }
    }
}

