/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.vis.jfree.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.vis.jfree.ClaimScaling;
import org.eclipse.trace4cps.vis.jfree.impl.Cell;
import org.eclipse.trace4cps.vis.jfree.impl.ClaimCell;
import org.eclipse.trace4cps.vis.jfree.impl.Partition;

public class ClaimPartition
extends Partition<IClaim> {
    public static ClaimPartition createActivityPartition(List<IClaim> claims, Collection<String> atts) {
        ClaimPartition partition = new ClaimPartition();
        HashMap<String, ClaimCell> m = new HashMap<String, ClaimCell>();
        for (IClaim a : claims) {
            String attVals = TraceHelper.getValues((IAttributeAware)a, atts, (boolean)false);
            ClaimCell cell = (ClaimCell)m.get(attVals);
            if (cell == null) {
                cell = partition.createCell(attVals);
                m.put(attVals, cell);
            }
            cell.add(a);
        }
        return partition;
    }

    public static ClaimPartition createResourcePartition(List<IClaim> claims, Collection<String> atts) {
        ClaimPartition partition = new ClaimPartition();
        HashMap<IResource, ClaimCell> m = new HashMap<IResource, ClaimCell>();
        for (IClaim claim : claims) {
            IResource r = claim.getResource();
            String attVals = TraceHelper.getValues((IAttributeAware)r, atts, (boolean)false);
            ClaimCell cell = (ClaimCell)m.get(r);
            if (cell == null) {
                cell = partition.createCell(attVals);
                m.put(r, cell);
            }
            cell.add(claim);
        }
        return partition;
    }

    private ClaimPartition() {
    }

    private ClaimCell createCell(String description) {
        ClaimCell c = new ClaimCell(description);
        this.cells.add(c);
        return c;
    }

    public void scaleClaims(ClaimScaling scaling) {
        if (scaling == ClaimScaling.NONE) {
            return;
        }
        for (Cell cell : this.cells) {
            ((ClaimCell)cell).scaleClaims(scaling);
        }
    }
}

