/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.io;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.kernel.core.io.IoAnalysis;
import org.eclipse.tracecompass.incubator.internal.kernel.core.io.IoPerProcessDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.internal.tmf.core.model.xy.TmfTreeXYCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class IoPerProcessDataProviderFactory
implements IDataProviderFactory {
    public static final IDataProviderDescriptor DESCRIPTOR = new DataProviderDescriptor.Builder().setId("org.eclipse.tracecompass.incubator.kernel.core.io.per.process").setName("Io Per Process Data Provider").setDescription("Shows the IO (read/write) per process in time").setProviderType(IDataProviderDescriptor.ProviderType.TREE_TIME_XY).build();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        @NonNull Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        if (traces.size() == 1) {
            return IoPerProcessDataProvider.create(trace);
        }
        return TmfTreeXYCompositeDataProvider.create((Collection)traces, (String)"Io Per Process Data Provider", (String)"org.eclipse.tracecompass.incubator.kernel.core.io.per.process");
    }

    public Collection<IDataProviderDescriptor> getDescriptors(@NonNull ITmfTrace trace) {
        IoAnalysis module = (IoAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, IoAnalysis.class, (String)"org.eclipse.tracecompass.incubator.internal.kernel.core.io");
        return module != null ? Collections.singletonList(DESCRIPTOR) : Collections.emptyList();
    }
}

