/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.presentation;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;

public interface IYAppearance {
    public String getName();

    public String getStyle();

    public RGBAColor getColor();

    public String getType();

    public int getWidth();

    default public String getSymbolStyle() {
        return "NONE";
    }

    default public int getSymbolSize() {
        return 3;
    }

    default public OutputElementStyle toOutputElementStyle() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"style-name", (Object)this.getName());
        builder.put((Object)"series-type", (Object)this.getType());
        builder.put((Object)"series-style", (Object)this.getStyle());
        builder.put((Object)"color", (Object)this.getColor());
        builder.put((Object)"width", (Object)this.getWidth());
        builder.put((Object)"symbol-type", (Object)this.getSymbolStyle());
        builder.put((Object)"height", (Object)this.getSymbolSize());
        return new OutputElementStyle(null, (Map<String, Object>)builder.build());
    }

    public static final class Style {
        public static final String NONE = "NONE";
        public static final String SOLID = "SOLID";
        public static final String DOT = "DOT";
        public static final String DASH = "DASH";
        public static final String DASHDOT = "DASHDOT";
        public static final String DASHDOTDOT = "DASHDOTDOT";

        private Style() {
        }
    }

    public static final class SymbolStyle {
        public static final String NONE = "NONE";
        public static final String DIAMOND = "DIAMOND";
        public static final String CIRCLE = "CIRCLE";
        public static final String SQUARE = "SQUARE";
        public static final String TRIANGLE = "TRIANGLE";
        public static final String INVERTED_TRIANGLE = "INVERTED_TRIANGLE";
        public static final String CROSS = "CROSS";
        public static final String PLUS = "PLUS";

        private SymbolStyle() {
        }
    }

    public static final class Type {
        public static final String LINE = "line";
        public static final String AREA = "area";
        public static final String SCATTER = "scatter";
        public static final String BAR = "bar";

        private Type() {
        }
    }
}

