/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.trace;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.CTFCallsite;
import org.eclipse.tracecompass.ctf.core.event.CTFClock;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceWriter;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.ctf.core.trace.Metadata;
import org.eclipse.tracecompass.internal.tmf.ctf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.ctf.core.event.aspect.CtfEventContextAspect;
import org.eclipse.tracecompass.internal.tmf.ctf.core.event.aspect.CtfPacketContextAspect;
import org.eclipse.tracecompass.internal.tmf.ctf.core.event.aspect.CtfPacketHeaderAspect;
import org.eclipse.tracecompass.internal.tmf.ctf.core.event.aspect.CtfStreamContextAspect;
import org.eclipse.tracecompass.internal.tmf.ctf.core.trace.iterator.CtfIterator;
import org.eclipse.tracecompass.internal.tmf.ctf.core.trace.iterator.CtfIteratorManager;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ICyclesConverter;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceKnownSize;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.trim.ITmfTrimmableTrace;
import org.eclipse.tracecompass.tmf.ctf.core.CtfConstants;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocationInfo;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfTmfContext;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventFactory;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventType;
import org.eclipse.tracecompass.tmf.ctf.core.event.aspect.CtfChannelAspect;
import org.eclipse.tracecompass.tmf.ctf.core.event.aspect.CtfCpuAspect;
import org.eclipse.tracecompass.tmf.ctf.core.event.lookup.CtfTmfCallsite;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.trace.Messages;

public class CtfTmfTrace
extends TmfTrace
implements ITmfPropertiesProvider,
ITmfPersistentlyIndexable,
ITmfTraceWithPreDefinedEvents,
ITmfTraceKnownSize,
ICyclesConverter,
ITmfTrimmableTrace {
    public static final String CLOCK_OFFSET = "clock_offset";
    protected static final int DEFAULT_CACHE_SIZE = 50000;
    protected static final @NonNull Collection<@NonNull ITmfEventAspect<?>> CTF_ASPECTS = ImmutableList.of((Object)TmfBaseAspects.getTimestampAspect(), (Object)new CtfChannelAspect(), (Object)((Object)new CtfCpuAspect()), (Object)TmfBaseAspects.getEventTypeAspect(), (Object)TmfBaseAspects.getContentsAspect(), CtfPacketHeaderAspect.getInstance(), CtfPacketContextAspect.getInstance(), CtfStreamContextAspect.getInstance(), CtfEventContextAspect.getInstance());
    private static final String CLOCK_HOST_PROPERTY = "uuid";
    private static final int CONFIDENCE = 10;
    private static final int MIN_CONFIDENCE = 1;
    private static final long REDUCTION_FACTOR = 4096L;
    private static final int CTF_AVG_EVENT_SIZE = 16;
    private final Map<@NonNull String, @NonNull CtfTmfEventType> fContainedEventTypes = Collections.synchronizedMap(new HashMap());
    private final CtfIteratorManager fIteratorManager = new CtfIteratorManager(this);
    private final @NonNull CtfTmfEventFactory fEventFactory;
    private CTFTrace fTrace;
    private UUID fUUID;
    private static int fCheckpointSize = -1;

    public CtfTmfTrace() {
        this(CtfTmfEventFactory.instance());
    }

    protected CtfTmfTrace(@NonNull CtfTmfEventFactory eventFactory) {
        this.fEventFactory = eventFactory;
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> eventType) throws TmfTraceException {
        this.setCacheSize();
        super.initTrace(resource, path, eventType);
        try {
            this.fTrace = new CTFTrace(path);
            CtfTmfContext ctx = (CtfTmfContext)this.seekEvent(0L);
            CtfTmfEvent event = this.getNext(ctx);
            if (ctx.getLocation().equals((Object)CtfIterator.NULL_LOCATION) || ctx.getCurrentEvent() == null) {
                this.setStartTime(TmfTimestamp.BIG_BANG);
            } else {
                ITmfTimestamp curTime = event.getTimestamp();
                this.setStartTime(curTime);
                this.setEndTime(curTime);
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try (CtfIterator iter = this.fIteratorManager.getIterator(ctx);){
                if (iter == null) {
                    throw new TmfTraceException("Failed to get CTF Iterator for path " + path);
                }
                HashSet<@NonNull TmfEventField> streamContextNames = new HashSet<TmfEventField>();
                for (IEventDeclaration ied : iter.getEventDeclarations()) {
                    CtfTmfEventType ctfTmfEventType = this.fContainedEventTypes.get(ied.getName());
                    if (ctfTmfEventType != null) continue;
                    ArrayList<TmfEventField> content = new ArrayList<TmfEventField>();
                    StructDeclaration fields = ied.getFields();
                    if (fields != null) {
                        for (String fieldName : fields.getFieldsList()) {
                            content.add(new TmfEventField((String)NonNullUtils.checkNotNull((Object)fieldName), null, null));
                        }
                    }
                    StructDeclaration streamContexts = ied.getStream().getEventContextDecl();
                    if (streamContextNames.isEmpty() && streamContexts != null) {
                        for (String fieldName : streamContexts.getFieldsList()) {
                            streamContextNames.add(new TmfEventField((String)NonNullUtils.checkNotNull((Object)("context." + fieldName)), null, null));
                        }
                    }
                    content.addAll(streamContextNames);
                    if (content.isEmpty()) continue;
                    TmfEventField contentTree = new TmfEventField(":root:", null, content.toArray(new ITmfEventField[content.size()]));
                    ctfTmfEventType = new CtfTmfEventType((String)NonNullUtils.checkNotNull((Object)ied.getName()), (ITmfEventField)contentTree);
                    this.fContainedEventTypes.put(ctfTmfEventType.getName(), ctfTmfEventType);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ctx.dispose();
            this.fUUID = this.fTrace.getUUID();
        }
        catch (CTFException e) {
            throw new TmfTraceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void dispose() {
        this.fIteratorManager.dispose();
        this.fContainedEventTypes.clear();
        if (this.fTrace != null) {
            this.fTrace = null;
        }
        super.dispose();
    }

    public IStatus validate(IProject project, String path) {
        boolean isMetadataFile = false;
        String pluginId = "org.eclipse.tracecompass.tmf.ctf.core";
        try {
            isMetadataFile = Metadata.preValidate((String)path);
        }
        catch (CTFException e) {
            return new Status(4, pluginId, String.valueOf(Messages.CtfTmfTrace_ReadingError) + ": " + e.toString(), (Throwable)e);
        }
        if (isMetadataFile) {
            try {
                CTFTrace trace = new CTFTrace(path);
                if (!trace.majorIsSet()) {
                    if (isMetadataFile) {
                        return new TraceValidationStatus(1, 2, pluginId, Messages.CtfTmfTrace_MajorNotSet, null);
                    }
                    return new Status(4, pluginId, Messages.CtfTmfTrace_MajorNotSet);
                }
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    CTFTraceReader ctfTraceReader = new CTFTraceReader(trace);
                    if (ctfTraceReader != null) {
                        ctfTraceReader.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                HashSet<String> eventNames = new HashSet<String>();
                for (ICTFStream stream : trace.getStreams()) {
                    for (IEventDeclaration ed : trace.getEventDeclarations(Long.valueOf(stream.getId()))) {
                        if (ed == null) continue;
                        eventNames.add(ed.getName());
                    }
                }
                return new CtfTraceValidationStatus(10, pluginId, trace.getEnvironment(), eventNames);
            }
            catch (BufferOverflowException | CTFException e) {
                return new TraceValidationStatus(1, 2, pluginId, String.valueOf(Messages.CtfTmfTrace_ReadingError) + ": " + e.toString(), e);
            }
        }
        return new Status(4, pluginId, Messages.CtfTmfTrace_ReadingError);
    }

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return CTF_ASPECTS;
    }

    public ITmfLocation getCurrentLocation() {
        return null;
    }

    public double getLocationRatio(ITmfLocation location) {
        CtfLocation curLocation = (CtfLocation)location;
        long startTime = this.getStartTime().getValue();
        double diff = curLocation.getLocationInfo().getTimestamp() - startTime;
        double total = this.getEndTime().getValue() - startTime;
        return Math.max(0.0, Math.min(1.0, diff / total));
    }

    public synchronized ITmfContext seekEvent(ITmfLocation location) {
        CtfLocation currentLocation = (CtfLocation)location;
        CtfTmfContext context = new CtfTmfContext(this);
        if (this.fTrace == null) {
            context.setLocation(null);
            context.setRank(-1L);
            return context;
        }
        if (currentLocation == null) {
            currentLocation = new CtfLocation(new CtfLocationInfo(0L, 0L));
            context.setRank(0L);
        } else {
            context.setRank(-1L);
        }
        context.setLocation((ITmfLocation)currentLocation);
        return context;
    }

    public synchronized ITmfContext seekEvent(double ratio) {
        CtfTmfContext context = new CtfTmfContext(this);
        if (this.fTrace == null) {
            context.setLocation(null);
            context.setRank(-1L);
            return context;
        }
        long end = this.getEndTime().getValue();
        long start = this.getStartTime().getValue();
        long diff = end - start;
        long ratioTs = Math.round((double)diff * ratio) + start;
        context.seek(ratioTs);
        context.setRank(-1L);
        return context;
    }

    public synchronized CtfTmfEvent getNext(ITmfContext context) {
        if (this.fTrace == null) {
            return null;
        }
        CtfTmfEvent event = null;
        if (context instanceof CtfTmfContext) {
            if (context.getLocation() == null || CtfLocation.INVALID_LOCATION.equals(context.getLocation().getLocationInfo())) {
                return null;
            }
            CtfTmfContext ctfContext = (CtfTmfContext)context;
            event = ctfContext.getCurrentEvent();
            if (event != null) {
                this.updateAttributes(context, (ITmfEvent)event);
                ctfContext.advance();
                ctfContext.increaseRank();
            }
        }
        return event;
    }

    public String getHostId() {
        String clockHost;
        CTFClock clock;
        CTFTrace trace = this.fTrace;
        if (trace != null && (clock = trace.getClock()) != null && (clockHost = (String)clock.getProperty(CLOCK_HOST_PROPERTY)) != null) {
            return clockHost;
        }
        return super.getHostId();
    }

    public @Nullable CtfTmfCallsite getCallsite(String eventName) {
        CTFTrace trace = this.fTrace;
        if (trace != null) {
            for (ICTFStream stream : this.fTrace.getStreams()) {
                for (IEventDeclaration eventDeclaration : stream.getEventDeclarations()) {
                    if (eventDeclaration == null || !Objects.equals(eventDeclaration.getName(), eventName) || eventDeclaration.getCallsites().isEmpty()) continue;
                    return new CtfTmfCallsite((CTFCallsite)eventDeclaration.getCallsites().get(0));
                }
            }
        }
        return null;
    }

    public @Nullable CtfTmfCallsite getCallsite(String eventName, long ip) {
        CtfTmfCallsite callsite = null;
        CTFTrace trace = this.fTrace;
        if (trace != null) {
            for (ICTFStream stream : trace.getStreams()) {
                for (IEventDeclaration eventDeclaration : stream.getEventDeclarations()) {
                    if (eventDeclaration == null || !Objects.equals(eventDeclaration.getName(), eventName)) continue;
                    for (CTFCallsite cs : eventDeclaration.getCallsites()) {
                        if (cs.getIp() < ip || callsite != null && cs.getIp() >= callsite.getIntructionPointer()) continue;
                        callsite = new CtfTmfCallsite(cs);
                    }
                }
            }
        }
        return callsite;
    }

    public Map<String, String> getEnvironment() {
        CTFTrace trace = this.fTrace;
        if (trace == null) {
            return Collections.emptyMap();
        }
        return trace.getEnvironment();
    }

    public UUID getUUID() {
        UUID uuid = this.fUUID;
        return uuid == null ? super.getUUID() : uuid;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        CTFTrace trace = this.fTrace;
        if (trace == null) {
            return properties;
        }
        properties.putAll(trace.getEnvironment());
        properties.put(CLOCK_OFFSET, Long.toUnsignedString(trace.getOffset()));
        properties.put(Messages.CtfTmfTrace_HostID, this.getHostId());
        return properties;
    }

    public long getOffset() {
        CTFTrace trace = this.fTrace;
        if (trace != null) {
            return trace.getOffset();
        }
        return 0L;
    }

    public long timestampCyclesToNanos(long cycles) {
        CTFTrace trace = this.fTrace;
        if (trace != null) {
            return trace.timestampCyclesToNanos(cycles);
        }
        return 0L;
    }

    public long timestampNanoToCycles(long nanos) {
        CTFTrace trace = this.fTrace;
        if (trace != null) {
            return trace.timestampNanoToCycles(nanos);
        }
        return 0L;
    }

    public Set<@NonNull CtfTmfEventType> getContainedEventTypes() {
        return ImmutableSet.copyOf(this.fContainedEventTypes.values());
    }

    public void registerEventType(CtfTmfEventType eventType) {
        this.fContainedEventTypes.put(eventType.getName(), eventType);
    }

    public CtfTmfEvent parseEvent(ITmfContext context) {
        CtfTmfEvent event = null;
        if (context instanceof CtfTmfContext) {
            ITmfContext tmpContext = this.seekEvent(context.getLocation());
            event = this.getNext(tmpContext);
        }
        return event;
    }

    protected void setCacheSize() {
        this.setCacheSize(50000);
    }

    public @NonNull CtfTmfEventFactory getEventFactory() {
        return this.fEventFactory;
    }

    public ITmfContext createIterator() {
        try {
            return new CtfIterator(this.fTrace, this);
        }
        catch (CTFException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return null;
        }
    }

    public ITmfContext createIterator(CtfLocationInfo ctfLocationData, long rank) {
        try {
            return new CtfIterator(this.fTrace, this, ctfLocationData, rank);
        }
        catch (CTFException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return null;
        }
    }

    public ITmfContext createIteratorFromContext(CtfTmfContext context) {
        return this.fIteratorManager.getIterator(context);
    }

    public void disposeContext(CtfTmfContext context) {
        this.fIteratorManager.removeIterator(context);
    }

    public @NonNull ITmfTimestamp createTimestamp(long ts) {
        return TmfTimestamp.fromNanos((long)this.getTimestampTransform().transform(ts));
    }

    public synchronized int getCheckpointSize() {
        if (fCheckpointSize == -1) {
            TmfCheckpoint c = new TmfCheckpoint(TmfTimestamp.fromNanos((long)0L), (ITmfLocation)new CtfLocation(0L, 0L), 0L);
            ByteBuffer b = ByteBuffer.allocate(1024);
            b.clear();
            c.serialize(b);
            fCheckpointSize = b.position();
        }
        return fCheckpointSize;
    }

    protected ITmfTraceIndexer createIndexer(int interval) {
        return new TmfBTreeTraceIndexer((ITmfTrace)this, interval);
    }

    public ITmfLocation restoreLocation(ByteBuffer bufferIn) {
        return new CtfLocation(bufferIn);
    }

    public boolean isComplete() {
        if (this.getResource() == null) {
            return true;
        }
        String host = null;
        String port = null;
        String sessionName = null;
        try {
            host = this.getResource().getPersistentProperty(CtfConstants.LIVE_HOST);
            port = this.getResource().getPersistentProperty(CtfConstants.LIVE_PORT);
            sessionName = this.getResource().getPersistentProperty(CtfConstants.LIVE_SESSION_NAME);
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return true;
        }
        return host == null || port == null || sessionName == null;
    }

    public void setComplete(boolean isComplete) {
        super.setComplete(isComplete);
        try {
            if (isComplete) {
                this.getResource().setPersistentProperty(CtfConstants.LIVE_HOST, null);
                this.getResource().setPersistentProperty(CtfConstants.LIVE_PORT, null);
                this.getResource().setPersistentProperty(CtfConstants.LIVE_SESSION_NAME, null);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    public int size() {
        long size = 0L;
        CTFTrace trace = this.fTrace;
        if (trace != null) {
            Iterable streams = trace.getStreams();
            for (ICTFStream stream : streams) {
                for (CTFStreamInput si : stream.getStreamInputs()) {
                    size += si.getFile().length();
                }
            }
        }
        return (int)(size / 4096L / 16L);
    }

    public int progress() {
        return (int)(this.getNbEvents() / 4096L);
    }

    public long cyclesToNanos(long cycles) {
        CTFTrace trace = this.fTrace;
        if (trace != null) {
            return this.fTrace.timestampCyclesToNanos(cycles - trace.getOffset());
        }
        return 0L;
    }

    public long nanosToCycles(long nanos) {
        CTFTrace trace = this.fTrace;
        if (trace != null) {
            return trace.timestampNanoToCycles(nanos) + this.fTrace.getOffset();
        }
        return 0L;
    }

    public ITmfTimestamp readStart() {
        return this.getStartTime();
    }

    public ITmfTimestamp readEnd() {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (CTFTraceReader reader = new CTFTraceReader(this.fTrace);){
                reader.goToLastEvent();
                long end = reader.getEndTime();
                return this.createTimestamp(end);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CTFException cTFException) {
            return null;
        }
    }

    public Path trim(@NonNull TmfTimeRange range, @NonNull Path destinationPath, @NonNull IProgressMonitor monitor) throws CoreException {
        CTFTrace trace = this.fTrace;
        if (trace == null) {
            return null;
        }
        try {
            CTFTraceWriter ctfWriter = new CTFTraceWriter(trace);
            String tracePath = destinationPath.toAbsolutePath().toString();
            ctfWriter.copyPackets(range.getStartTime().toNanos(), range.getEndTime().toNanos(), tracePath);
            return destinationPath;
        }
        catch (CTFException e) {
            Activator.getDefault().logError("Error writing trace : " + destinationPath, e);
            return null;
        }
    }
}

