/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.closure;

import java.util.ArrayList;

public final class LineNumberComputer {
    public static int[] computeLineTable(String source) {
        ArrayList<Integer> lineEndOffsets = new ArrayList<Integer>();
        int index = 0;
        while (index < source.length()) {
            char ch = source.charAt(index);
            if (LineNumberComputer.isLineTerminator(ch)) {
                if (index + 1 < source.length() && ch == '\r' && source.charAt(index + 1) == '\n') {
                    ++index;
                }
                lineEndOffsets.add(index);
            }
            ++index;
        }
        return LineNumberComputer.toIntArray(lineEndOffsets);
    }

    private static int[] toIntArray(ArrayList<Integer> integers) {
        int[] ret = new int[integers.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = integers.get(i);
            ++i;
        }
        return ret;
    }

    private static boolean isLineTerminator(char ch) {
        switch (ch) {
            case '\n': 
            case '\r': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }
}

