/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.enumeration;

import java.math.BigInteger;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryIntegerParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryStringParser;

public final class EnumeratorParser
implements ICommonTreeParser {
    public static final EnumeratorParser INSTANCE = new EnumeratorParser();

    private EnumeratorParser() {
    }

    @Override
    public Long parse(CommonTree enumerator, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        EnumDeclaration enumDeclaration = ((Param)param).fEnumDeclaration;
        List children = enumerator.getChildren();
        long low = 0L;
        long high = 0L;
        boolean valueSpecified = false;
        String label = null;
        for (CommonTree child : children) {
            if (TsdlUtils.isAnyUnaryString(child)) {
                label = UnaryStringParser.INSTANCE.parse(child, null);
                continue;
            }
            if (child.getType() == 96) {
                valueSpecified = true;
                high = low = UnaryIntegerParser.INSTANCE.parse((CommonTree)child.getChild(0), null).longValue();
                continue;
            }
            if (child.getType() == 97) {
                valueSpecified = true;
                low = UnaryIntegerParser.INSTANCE.parse((CommonTree)child.getChild(0), null);
                high = UnaryIntegerParser.INSTANCE.parse((CommonTree)child.getChild(1), null);
                continue;
            }
            throw TsdlUtils.childTypeError(child);
        }
        if (low > high) {
            throw new ParseException("enum low value greater than high value");
        }
        if (valueSpecified && !enumDeclaration.add(low, high, label)) {
            Activator.log(2, "enum declarator values overlap. " + enumDeclaration.getLabels() + " and " + label);
        } else if (!valueSpecified && !enumDeclaration.add(label)) {
            throw new ParseException("enum cannot add element " + label);
        }
        IntegerDeclaration enumContainerType = enumDeclaration.getContainerType();
        if (valueSpecified && (BigInteger.valueOf(low).compareTo(enumContainerType.getMinValue()) < 0 || BigInteger.valueOf(high).compareTo(enumContainerType.getMaxValue()) > 0)) {
            throw new ParseException(String.format("enum value ( %d - %d ) is not in range ( %d - %d )", low, high, enumContainerType.getMinValue(), enumContainerType.getMinValue()));
        }
        return high;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final EnumDeclaration fEnumDeclaration;

        public Param(EnumDeclaration enumDeclaration) {
            this.fEnumDeclaration = enumDeclaration;
        }
    }
}

