/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.preferences.EncodingSettings;

public class XMLFilesPreferencePage
extends AbstractPreferencePage {
    protected EncodingSettings fEncodingSettings = null;
    private Combo fDefaultSuffix;
    private List fValidExtensions;

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.xml.ui.webx0060");
        this.createContentsForCreatingGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void createContentsForCreatingGroup(Composite parent) {
        Group creatingGroup = this.createGroup(parent, 2);
        creatingGroup.setText(XMLUIMessages.Creating_files);
        this.createLabel((Composite)creatingGroup, XMLUIMessages.XMLFilesPreferencePage_ExtensionLabel);
        this.fDefaultSuffix = this.createDropDownBox((Composite)creatingGroup);
        Object[] validExtensions = this.getValidExtensions().toArray(new String[0]);
        Arrays.sort(validExtensions);
        this.fDefaultSuffix.setItems((String[])validExtensions);
        this.fDefaultSuffix.addSelectionListener((SelectionListener)this);
        Label label = this.createLabel((Composite)creatingGroup, XMLUIMessages.Encoding_desc);
        ((GridData)label.getLayoutData()).horizontalSpan = 2;
        this.fEncodingSettings = new EncodingSettings((Composite)creatingGroup, XMLUIMessages.Encoding);
        ((GridData)this.fEncodingSettings.getLayoutData()).horizontalSpan = 2;
    }

    public void dispose() {
        this.fDefaultSuffix.removeModifyListener((ModifyListener)this);
        super.dispose();
    }

    protected void doSavePreferenceStore() {
        XMLCorePlugin.getDefault().savePluginPreferences();
    }

    protected IContentType getContentType() {
        return Platform.getContentTypeManager().getContentType(ContentTypeIdForXML.ContentTypeID_XML);
    }

    private List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType type = this.getContentType();
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    protected Preferences getModelPreferences() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected void initializeValues() {
        this.initializeValuesForCreatingGroup();
    }

    protected void initializeValuesForCreatingGroup() {
        String suffix = this.getModelPreferences().getString("defaultExtension");
        this.fDefaultSuffix.setText(suffix);
        String encoding = this.getModelPreferences().getString("outputCodeset");
        this.fEncodingSettings.setIANATag(encoding);
    }

    protected void performDefaults() {
        this.performDefaultsForCreatingGroup();
        super.performDefaults();
    }

    protected void performDefaultsForCreatingGroup() {
        String suffix = this.getModelPreferences().getDefaultString("defaultExtension");
        this.fDefaultSuffix.setText(suffix);
        String encoding = this.getModelPreferences().getDefaultString("outputCodeset");
        this.fEncodingSettings.setIANATag(encoding);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }

    protected void storeValues() {
        this.storeValuesForCreatingGroup();
    }

    protected void storeValuesForCreatingGroup() {
        String suffix = this.fDefaultSuffix.getText();
        this.getModelPreferences().setValue("defaultExtension", suffix);
        this.getModelPreferences().setValue("outputCodeset", this.fEncodingSettings.getIANATag());
    }

    protected void validateValues() {
        boolean isValid = false;
        Iterator i = this.getValidExtensions().iterator();
        while (i.hasNext() && !isValid) {
            String extension = (String)i.next();
            isValid = extension.equalsIgnoreCase(this.fDefaultSuffix.getText());
        }
        if (!isValid) {
            this.setErrorMessage(NLS.bind((String)XMLUIMessages.XMLFilesPreferencePage_ExtensionError, (Object)this.getValidExtensions().toString()));
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }
}

