/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.search.ISearchEngine;
import org.eclipse.help.search.ISearchEngineResult;
import org.eclipse.help.search.ISearchEngineResultCollector;
import org.eclipse.help.search.ISearchScope;

public final class WebSearch
implements ISearchEngine {
    private static final char C_START = '{';
    private static final char C_STOP = '}';

    @Override
    public void run(String query, ISearchScope scope, ISearchEngineResultCollector collector, IProgressMonitor monitor) throws CoreException {
        collector.accept(new SearchResult(query, ((Scope)scope).getURLTemplate()));
    }

    private static String composeURL(String query, String urlTemplate) {
        StringBuilder result = new StringBuilder();
        boolean inSubstitution = false;
        int varStart = -1;
        int i = 0;
        while (i < urlTemplate.length()) {
            char c = urlTemplate.charAt(i);
            if (c == '{' && !inSubstitution) {
                char c2;
                if (i < urlTemplate.length() - 1 && (c2 = urlTemplate.charAt(i + 1)) == '{') {
                    result.append(c);
                    ++i;
                } else {
                    inSubstitution = true;
                    varStart = i;
                }
            } else if (c == '}' && inSubstitution) {
                char c2;
                if (i < urlTemplate.length() - 1 && (c2 = urlTemplate.charAt(i + 1)) == '}') {
                    result.append(c);
                    ++i;
                } else {
                    if (varStart != -1) {
                        String key = urlTemplate.substring(varStart + 1, i);
                        String value = WebSearch.getVariable(key, query);
                        result.append(value);
                    }
                    inSubstitution = false;
                }
            } else if (!inSubstitution) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private static String getVariable(String key, String query) {
        if (key.equals("expression")) {
            return query;
        }
        return key;
    }

    public static class Scope
    implements ISearchScope {
        private String urlTemplate;

        public Scope(String urlTemplate) {
            this.urlTemplate = urlTemplate;
        }

        public String getURLTemplate() {
            return this.urlTemplate;
        }
    }

    private static class SearchResult
    implements ISearchEngineResult {
        private String query;
        private String urlTemplate;

        public SearchResult(String query, String urlTemplate) {
            this.query = query;
            this.urlTemplate = urlTemplate;
        }

        @Override
        public String getDescription() {
            return HelpBaseResources.WebSearch_click;
        }

        @Override
        public String getHref() {
            String equery;
            String href = null;
            try {
                equery = URLEncoder.encode(this.query, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                equery = this.query;
            }
            href = WebSearch.composeURL(equery, this.urlTemplate);
            return href;
        }

        @Override
        public String getLabel() {
            return HelpBaseResources.WebSearch_label;
        }

        @Override
        public float getScore() {
            return 1.0f;
        }

        @Override
        public IHelpResource getCategory() {
            return null;
        }

        @Override
        public boolean getForceExternalWindow() {
            return true;
        }

        @Override
        public String toAbsoluteHref(String href, boolean frames) {
            return href;
        }
    }
}

