/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.annotations;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.math.Fraction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.markers.ITimeReference;
import org.eclipse.tracecompass.tmf.core.markers.TimeReference;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;

public class PeriodicAnnotationProvider
implements IOutputAnnotationProvider {
    private static final TmfModelResponse<AnnotationModel> EMPTY_MODEL_RESPONSE = new TmfModelResponse<AnnotationModel>(new AnnotationModel(Collections.emptyMap()), ITmfResponse.Status.COMPLETED, "");
    private final String fCategory;
    private final double fPeriod;
    private final long fPeriodInteger;
    private @Nullable Fraction fPeriodFraction;
    private final long fRollover;
    private final RGBAColor fColor1;
    private final @Nullable RGBAColor fColor2;
    private ITimeReference fReference;

    public PeriodicAnnotationProvider(String category, ITimeReference reference, double period, long rollover, RGBAColor color1, @Nullable RGBAColor color2) {
        if (period <= 0.0) {
            throw new IllegalArgumentException("period cannot be less than or equal to zero");
        }
        if (rollover < 0L) {
            throw new IllegalArgumentException("rollover cannot be less than zero");
        }
        this.fCategory = category;
        this.fReference = reference;
        this.fColor1 = color1;
        this.fColor2 = color2;
        this.fPeriod = period;
        this.fPeriodInteger = (long)period;
        try {
            this.fPeriodFraction = Fraction.getFraction((double)(this.fPeriod - (double)this.fPeriodInteger));
        }
        catch (ArithmeticException arithmeticException) {
            this.fPeriodFraction = null;
        }
        this.fRollover = rollover;
    }

    private ITimeReference adjustReference(ITimeReference baseReference, long time) {
        long offsetIndex = (long)((double)(time - baseReference.getTime()) / this.fPeriod);
        long offsetTime = 0L;
        Fraction fraction = this.fPeriodFraction;
        if (fraction != null) {
            offsetIndex -= offsetIndex % (long)fraction.getDenominator();
            offsetTime = offsetIndex * this.fPeriodInteger + offsetIndex / (long)fraction.getDenominator() * (long)fraction.getNumerator();
        } else {
            offsetTime = Math.round((double)offsetIndex * this.fPeriod);
        }
        return new TimeReference(baseReference.getTime() + offsetTime, baseReference.getIndex() + offsetIndex);
    }

    @Override
    public @NonNull TmfModelResponse<@NonNull AnnotationCategoriesModel> fetchAnnotationCategories(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse<AnnotationCategoriesModel>(new AnnotationCategoriesModel(Collections.singletonList(this.fCategory)), ITmfResponse.Status.COMPLETED, "");
    }

    @Override
    public @NonNull TmfModelResponse<@NonNull AnnotationModel> fetchAnnotations(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        OutputElementStyle[] styles;
        RGBAColor color2;
        List<Long> times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        if (times == null) {
            return EMPTY_MODEL_RESPONSE;
        }
        int size = times.size() - 1;
        long startTime = times.get(0);
        long endTime = times.get(size);
        long resolution = (endTime - startTime) / (long)size;
        if (startTime > endTime) {
            return EMPTY_MODEL_RESPONSE;
        }
        long step = Math.max(Math.round(this.fPeriod), resolution);
        styles = new OutputElementStyle[]{PeriodicAnnotationProvider.generateOutputElementStyle(this.fColor1), (color2 = this.fColor2) == null ? styles[0] : PeriodicAnnotationProvider.generateOutputElementStyle(color2)};
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        long time = startTime - Math.max(Math.round(1.5 * this.fPeriod), resolution);
        ITimeReference reference = this.adjustReference(this.fReference, time);
        Annotation annotation = null;
        while (true) {
            long index = Math.round((double)(time - reference.getTime()) / this.fPeriod) + reference.getIndex();
            long markerTime = Math.round((double)(index - reference.getIndex()) * this.fPeriod) + reference.getTime();
            long duration = this.fColor2 == null ? 0L : Math.round((double)(index + 1L - reference.getIndex()) * this.fPeriod) + reference.getTime() - markerTime;
            long labelIndex = index;
            if (this.fRollover != 0L && (labelIndex %= this.fRollover) < 0L) {
                labelIndex += this.fRollover;
            }
            if ((markerTime >= startTime || markerTime + duration > startTime) && annotation != null) {
                annotations.add(annotation);
            }
            if (this.isApplicable(labelIndex)) {
                OutputElementStyle style = Objects.requireNonNull(index % 2L == 0L ? styles[0] : styles[1]);
                annotation = new Annotation(markerTime, duration, -1L, this.getAnnotationLabel(labelIndex), style);
            } else {
                annotation = null;
            }
            if (markerTime > endTime || monitor != null && monitor.isCanceled()) {
                if (annotation == null || !this.isApplicable(labelIndex)) break;
                annotations.add(annotation);
                break;
            }
            time += step;
        }
        HashMap<String, Collection<Annotation>> model = new HashMap<String, Collection<Annotation>>();
        model.put(this.fCategory, annotations);
        return new TmfModelResponse<AnnotationModel>(new AnnotationModel(model), ITmfResponse.Status.COMPLETED, "");
    }

    private static OutputElementStyle generateOutputElementStyle(RGBAColor color) {
        String colorString = color.toString().substring(0, 7);
        return new OutputElementStyle(null, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)colorString, (Object)"color", (Object)colorString, (Object)"opacity", (Object)Float.valueOf((float)((double)color.getAlpha() / 255.0))));
    }

    public double getPeriod() {
        return this.fPeriod;
    }

    public String getAnnotationLabel(long index) {
        return (String)NonNullUtils.checkNotNull((Object)Long.toString(index));
    }

    public boolean isApplicable(long index) {
        return true;
    }
}

