/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.uibuilder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ease.modules.platform.uibuilder.IPlaceHolder;
import org.eclipse.ease.modules.platform.uibuilder.IRenderer;
import org.eclipse.ease.modules.platform.uibuilder.Location;
import org.eclipse.ease.modules.platform.uibuilder.Reference;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class ViewModel {
    private final List<Object> fElements = new ArrayList<Object>();
    private int fRows = 0;
    private int fColumns = 0;
    private final IRenderer fRenderer;

    public ViewModel(IRenderer renderer) {
        this.fRenderer = renderer;
        this.fRenderer.setViewModel(this);
    }

    public List<Object> getElements() {
        return this.fElements;
    }

    public void insertElement(Object element, Location location) {
        if (location.getPosition().x == Location.DYNAMIC_POSITION || location.getPosition().y == Location.DYNAMIC_POSITION) {
            location.getPosition().x = 1;
            location.getPosition().y = 1;
            int index = this.fElements.size() - 1;
            while (index >= 0) {
                if (!(this.fElements.get(index) instanceof IPlaceHolder) && !(this.fElements.get(index) instanceof Reference)) {
                    Point target = this.indexToPoint(index + 1);
                    location.getPosition().x = target.x;
                    location.getPosition().y = target.y;
                    break;
                }
                --index;
            }
        }
        this.ensureColumnCount(location.getPosition().x + location.getLayoutData().horizontalSpan - 1);
        this.ensureRowCount(location.getPosition().y + location.getLayoutData().verticalSpan - 1);
        this.splitSpanElements(new Rectangle(location.getPosition().x, location.getPosition().y, location.getLayoutData().horizontalSpan, location.getLayoutData().verticalSpan));
        this.replaceElementAt(location.getPosition(), element);
        if (location.getLayoutData().horizontalSpan > 1 || location.getLayoutData().verticalSpan > 1) {
            Reference reference = new Reference(element);
            int width = 0;
            while (width < location.getLayoutData().horizontalSpan) {
                int height = 0;
                while (height < location.getLayoutData().verticalSpan) {
                    if (width > 0 || height > 0) {
                        this.replaceElementAt(new Point(location.getPosition().x + width, location.getPosition().y + height), reference);
                    }
                    ++height;
                }
                ++width;
            }
        }
        if (element instanceof Control) {
            ((Control)element).setLayoutData((Object)location.getLayoutData());
        }
    }

    public int getColumnCount() {
        return this.fColumns;
    }

    public int getRowCount() {
        return this.fRows;
    }

    private void replaceElementAt(Point position, Object element) {
        int index = this.pointToIndex(position);
        Object oldElement = this.fElements.remove(index);
        if (oldElement instanceof Control) {
            ((Control)oldElement).dispose();
        }
        this.fElements.add(index, element);
    }

    private void splitSpanElements(Rectangle rectangle) {
        int column = rectangle.x;
        while (column < rectangle.x + rectangle.width) {
            int row = rectangle.y;
            while (row < rectangle.y + rectangle.height) {
                Object element = this.fElements.get(this.pointToIndex(new Point(column, row)));
                if (element instanceof Reference) {
                    this.splitElement(((Reference)element).getDelegate());
                }
                ++row;
            }
            ++column;
        }
    }

    private void splitElement(Object elementToSplit) {
        int index = 0;
        while (index < this.fElements.size()) {
            Point position;
            if (this.fElements.get(index).equals(elementToSplit)) {
                position = this.indexToPoint(index);
                this.replaceElementAt(position, this.fRenderer.createPlaceHolder(position));
            } else if (this.fElements.get(index) instanceof Reference && ((Reference)this.fElements.get(index)).getDelegate().equals(elementToSplit)) {
                position = this.indexToPoint(index);
                this.replaceElementAt(position, this.fRenderer.createPlaceHolder(position));
            }
            ++index;
        }
    }

    public Point indexToPoint(int index) {
        return new Point(index % this.fColumns + 1, index / this.fColumns + 1);
    }

    private int pointToIndex(Point point) {
        return (point.y - 1) * this.fColumns + point.x - 1;
    }

    private void ensureColumnCount(int columns) {
        while (this.fColumns < columns) {
            this.addColumn();
        }
    }

    private void addColumn() {
        if (this.fElements.isEmpty()) {
            IPlaceHolder placeHolder = this.fRenderer.createPlaceHolder(new Point(1, 1));
            this.fElements.add(placeHolder);
            this.fRows = 1;
            this.fColumns = 1;
        } else {
            int row = this.fRows - 1;
            while (row >= 0) {
                Point position = new Point(this.fColumns + 1, row + 1);
                IPlaceHolder placeHolder = this.fRenderer.createPlaceHolder(position);
                this.fElements.add(this.pointToIndex(position), placeHolder);
                --row;
            }
            ++this.fColumns;
        }
    }

    private void ensureRowCount(int rows) {
        while (this.fRows < rows) {
            this.addRow();
        }
    }

    private void addRow() {
        if (this.fElements.isEmpty()) {
            IPlaceHolder placeHolder = this.fRenderer.createPlaceHolder(new Point(1, 1));
            this.fElements.add(placeHolder);
            this.fRows = 1;
            this.fColumns = 1;
        } else {
            ++this.fRows;
            int column = 1;
            while (column <= this.fColumns) {
                IPlaceHolder placeHolder = this.fRenderer.createPlaceHolder(new Point(column, this.fRows));
                this.fElements.add(placeHolder);
                ++column;
            }
        }
    }

    public void setColumnCount(int columns) {
        this.ensureColumnCount(columns);
    }
}

