/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.BinaryFile;
import org.eclipse.cdt.utils.coff.parser.PEBinaryObject64;
import org.eclipse.cdt.utils.coff.parser.PEParser64;
import org.eclipse.core.runtime.IPath;

public class PEBinaryArchive64
extends BinaryFile
implements IBinaryParser.IBinaryArchive {
    ArrayList<IBinaryParser.IBinaryObject> children;

    public PEBinaryArchive64(PEParser64 parser, IPath path) throws IOException {
        super(parser, path, 8);
        new AR(path.toOSString()).dispose();
        this.children = new ArrayList(5);
    }

    @Override
    public IBinaryParser.IBinaryObject[] getObjects() {
        if (this.hasChanged()) {
            this.children.clear();
            AR ar = null;
            try {
                ar = new AR(this.getPath().toOSString());
                AR.ARHeader[] headers = ar.getHeaders();
                this.addArchiveMembers(headers, this.children);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (ar != null) {
                ar.dispose();
            }
            this.children.trimToSize();
        }
        return this.children.toArray(new IBinaryParser.IBinaryObject[0]);
    }

    protected void addArchiveMembers(AR.ARHeader[] headers, ArrayList<IBinaryParser.IBinaryObject> children2) {
        int i = 0;
        while (i < headers.length) {
            PEBinaryObject64 bin = new PEBinaryObject64(this.getBinaryParser(), this.getPath(), headers[i]);
            this.children.add(bin);
            ++i;
        }
    }
}

