/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.util.ProxyUtil;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.util.ResourceLocator;
import org.osgi.framework.Bundle;

public class PluginIndex {
    private static final String COMPLETE_FILENAME = "indexed_complete";
    private String pluginId;
    private String path;
    private SearchIndex targetIndex;
    private List<String> indexIDs;
    private List<String> resolvedPaths;

    public PluginIndex(String pluginId, String path, SearchIndex targetIndex) {
        this.pluginId = pluginId;
        this.path = path;
        this.targetIndex = targetIndex;
    }

    private void resolve() {
        if (this.indexIDs != null) {
            return;
        }
        this.indexIDs = new ArrayList<String>();
        this.resolvedPaths = new ArrayList<String>();
        Bundle bundle = Platform.getBundle((String)this.pluginId);
        if (bundle == null) {
            return;
        }
        boolean found = false;
        ArrayList availablePrefixes = ResourceLocator.getPathPrefix((String)this.targetIndex.getLocale());
        for (String prefix : availablePrefixes) {
            URL resolved;
            Path prefixedPath = new Path(String.valueOf(prefix) + this.path);
            URL url = FileLocator.find((Bundle)bundle, (IPath)prefixedPath, null);
            if (url == null) continue;
            found = true;
            if (!this.isCompatible(bundle, (IPath)prefixedPath)) continue;
            try {
                resolved = FileLocator.resolve((URL)url);
            }
            catch (IOException ioe) {
                Platform.getLog(this.getClass()).error("Help index directory at " + prefixedPath + " for plugin " + bundle.getSymbolicName() + " cannot be resolved.", (Throwable)ioe);
                continue;
            }
            if ("file".equals(resolved.getProtocol())) {
                this.indexIDs.add(this.getIndexId(prefix));
                this.resolvedPaths.add(resolved.getFile());
                if (!this.isComplete(bundle, (IPath)prefixedPath)) continue;
                break;
            }
            try {
                URL localURL = FileLocator.toFileURL((URL)url);
                if (!"file".equals(localURL.getProtocol())) continue;
                this.indexIDs.add(this.getIndexId(prefix));
                this.resolvedPaths.add(localURL.getFile());
                if (!this.isComplete(bundle, (IPath)prefixedPath)) continue;
                break;
            }
            catch (IOException ioe) {
                Platform.getLog(this.getClass()).error("Help index directory at " + prefixedPath + " for plugin " + bundle.getSymbolicName() + " cannot be resolved.", (Throwable)ioe);
            }
        }
        if (!found) {
            Platform.getLog(this.getClass()).error("Help index declared, but missing for plugin " + this.getPluginId() + ".");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCompatible(Bundle bundle, IPath prefixedPath) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)prefixedPath.append("indexed_dependencies"), null);
        if (url == null) {
            Platform.getLog(this.getClass()).error(prefixedPath.append("indexed_dependencies") + " file missing from help index \"" + this.path + "\" of plugin " + this.getPluginId(), null);
            return false;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream in = ProxyUtil.getStream(url);){
                Properties prop = new Properties();
                prop.load(in);
                String lucene = prop.getProperty("lucene");
                String analyzer = prop.getProperty("analyzer");
                if (this.targetIndex.isLuceneCompatible(lucene)) {
                    if (this.targetIndex.isAnalyzerCompatible(analyzer)) return true;
                }
                String message = "Unable to consume Lucene index from bundle '" + bundle.toString() + "'. The index should be rebuilt with Lucene 8.4.1";
                Platform.getLog(this.getClass()).warn(message);
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (IOException ioe) {
            Platform.getLog(this.getClass()).error("IOException accessing prebuilt index.", (Throwable)ioe);
        }
        return true;
    }

    private boolean isComplete(Bundle bundle, IPath prefixedPath) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)prefixedPath.append(COMPLETE_FILENAME), null);
        return url != null;
    }

    private String getIndexId(String prefix) {
        if (prefix.length() == 0) {
            return "/";
        }
        return "/" + prefix.substring(0, prefix.length() - 1);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PluginIndex)) {
            return false;
        }
        PluginIndex index = (PluginIndex)obj;
        return this.pluginId.equals(index.pluginId) && this.path.equals(index.path);
    }

    public int hashCode() {
        return this.pluginId.hashCode() + this.path.hashCode();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.pluginId);
        ret.append(":");
        ret.append(this.path);
        ret.append("=");
        if (this.indexIDs == null) {
            ret.append("unresolved");
        } else {
            int i = 0;
            while (i < this.indexIDs.size()) {
                ret.append(this.indexIDs.get(i));
                ret.append("@");
                ret.append(this.resolvedPaths.get(i));
                ++i;
            }
        }
        return ret.toString();
    }

    public List<String> getIDs() {
        this.resolve();
        return this.indexIDs;
    }

    public List<String> getPaths() {
        this.resolve();
        return this.resolvedPaths;
    }

    public String getPluginId() {
        return this.pluginId;
    }
}

