/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.analysis;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.analysis.VirtualEnvironment;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.analysis.VirtualMachineModelAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class VirtualEnvironmentBuilder
extends VirtualEnvironment {
    private static final long ANALYSIS_BUFFER = 100000000L;
    private final ITmfStateSystemBuilder fStateSystem;
    private final VirtualMachineModelAnalysis fAnalysis;

    public VirtualEnvironmentBuilder(ITmfStateSystemBuilder stateSystem, VirtualMachineModelAnalysis analysis) {
        super((ITmfStateSystem)stateSystem);
        this.fStateSystem = stateSystem;
        this.fAnalysis = analysis;
    }

    private void waitAnalysis(ITmfEvent event) {
        long ts = event.getTimestamp().toNanos() + 100000000L;
        while (!this.fAnalysis.isQueryable(ts)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    @Override
    public VirtualMachine getCurrentMachine(ITmfEvent event) {
        this.waitAnalysis(event);
        return super.getCurrentMachine(event);
    }

    @Override
    public @Nullable VirtualCPU getVirtualCpu(@NonNull ITmfEvent event, @NonNull HostThread ht) {
        this.waitAnalysis(event);
        return super.getVirtualCpu(event, ht);
    }

    @Override
    public @Nullable VirtualMachine getGuestMachine(@NonNull ITmfEvent event, @NonNull HostThread ht) {
        this.waitAnalysis(event);
        return super.getGuestMachine(event, ht);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine getCurrentMachineBuild(ITmfEvent event) {
        VirtualMachine machine = this.innerGetCurrentMachine(event);
        if (machine == null) {
            ITmfStateSystemBuilder iTmfStateSystemBuilder = this.fStateSystem;
            synchronized (iTmfStateSystemBuilder) {
                String hostId = event.getTrace().getHostId();
                machine = VirtualEnvironmentBuilder.createMachine(this.fStateSystem, event.getTimestamp().toNanos(), hostId, String.valueOf(event.getTrace().getName()));
                this.fKnownMachines.put(hostId, machine);
            }
        }
        return machine;
    }

    public @Nullable VirtualCPU getVirtualCpuBuild(ITmfEvent event, HostThread ht) {
        return super.getVirtualCpu(event, ht);
    }

    public @Nullable VirtualMachine getGuestMachineBuild(ITmfEvent event, HostThread ht) {
        return super.getGuestMachine(event, ht);
    }

    private static VirtualMachine createMachine(ITmfStateSystemBuilder ss, long ts, String hostId, String traceName) {
        int quark = ss.getQuarkAbsoluteAndAdd(new String[]{hostId});
        ss.modifyAttribute(ts, (Object)traceName, quark);
        return VirtualMachine.newUnknownMachine(hostId, traceName);
    }

    public void setGuestMachine(VirtualMachine vm, HostThread ht) {
        this.fTidToVm.put(ht, vm);
    }

    public void setGuestCpu(VirtualCPU virtualCPU, HostThread ht) {
        this.fTidToVcpu.put((Object)ht, (Object)virtualCPU);
    }
}

