/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.ObjectUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class TmfEventField
implements ITmfEventField {
    private final @NonNull String fName;
    private final @Nullable Object fValue;
    private final @NonNull Map<String, ITmfEventField> fFields;

    public TmfEventField(@NonNull String name, @Nullable Object value, ITmfEventField @Nullable [] fields) {
        this.fName = name;
        this.fValue = value;
        if (fields == null) {
            this.fFields = ImmutableMap.of();
        } else {
            ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
            Arrays.stream(fields).forEach(t -> {
                ImmutableMap.Builder builder2 = mapBuilder.put((Object)t.getName(), t);
            });
            this.fFields = mapBuilder.build();
        }
    }

    public TmfEventField(TmfEventField field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this.fName = field.fName;
        this.fValue = field.fValue;
        this.fFields = field.fFields;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Object getValue() {
        return this.fValue;
    }

    @Override
    public final Collection<String> getFieldNames() {
        return this.fFields.keySet();
    }

    public final Collection<ITmfEventField> getFields() {
        return this.fFields.values();
    }

    @Override
    public ITmfEventField getField(String ... path) {
        if (path.length == 1) {
            return this.fFields.get(path[0]);
        }
        ITmfEventField field = this;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if ((field = field.getField(name)) == null) {
                return null;
            }
            ++n2;
        }
        return field;
    }

    public static final @NonNull ITmfEventField makeRoot(String[] labels) {
        ITmfEventField[] fields = new ITmfEventField[labels.length];
        int i = 0;
        while (i < labels.length) {
            String label = (String)NonNullUtils.checkNotNull((Object)labels[i]);
            fields[i] = new TmfEventField(label, null, null);
            ++i;
        }
        return new TmfEventField(":root:", null, fields);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + ObjectUtils.deepHashCode((Object)this.getValue());
        result = 31 * result + this.fFields.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        TmfEventField other = (TmfEventField)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!ObjectUtils.deepEquals((Object)this.getValue(), (Object)other.getValue())) {
            return false;
        }
        return this.fFields.equals(other.fFields);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        if (this.fName.equals(":root:")) {
            this.appendSubFields(ret);
        } else {
            ret.append(this.fName);
            ret.append('=');
            ret.append(this.fValue);
            if (!this.fFields.isEmpty()) {
                ret.append(" [");
                this.appendSubFields(ret);
                ret.append(']');
            }
        }
        return ret.toString();
    }

    private void appendSubFields(StringBuilder sb) {
        Joiner joiner = Joiner.on((String)", ").skipNulls();
        sb.append(joiner.join(this.getFields()));
    }

    @Override
    public String getFormattedValue() {
        return this.getValue().toString();
    }
}

