/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.Activator;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.BookmarkQueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.QueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.Bookmark;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.ExperimentManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.QueryParametersUtil;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

@Path(value="/experiments/{expUUID}/bookmarks")
@Tag(name="Bookmarks")
public class BookmarkManagerService {
    private static final String BOOKMARK_UUID = "uuid";
    private static final String BOOKMARK_NAME = "name";
    private static final String BOOKMARK_START = "start";
    private static final String BOOKMARK_END = "end";
    private static final String BOOKMARK_DEFAULT_COLOR = "RGBA {255, 0, 0, 128}";

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get all bookmarks for an experiment", responses={@ApiResponse(responseCode="200", description="Returns the list of bookmarks", content={@Content(array=@ArraySchema(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Bookmark.class)))}), @ApiResponse(responseCode="404", description="No such experiment", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getBookmarks(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID) {
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such experiment").build();
        }
        IFile editorFile = TmfTraceManager.getInstance().getTraceEditorFile((ITmfTrace)experiment);
        if (editorFile == null) {
            return Response.ok(Collections.emptyList()).build();
        }
        try {
            IMarker[] markers = BookmarkManagerService.findBookmarkMarkers(editorFile);
            List<Bookmark> bookmarks = BookmarkManagerService.markersToBookmarks(markers);
            return Response.ok(bookmarks).build();
        }
        catch (CoreException e) {
            Activator.getInstance().logError("Failed to get bookmarks", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{bookmarkUUID}")
    @Produces(value={"application/json"})
    @Operation(summary="Get a specific bookmark from an experiment", responses={@ApiResponse(responseCode="200", description="Returns the bookmark", content={@Content(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Bookmark.class))}), @ApiResponse(responseCode="404", description="Experiment or bookmark not found", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getBookmark(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="Bookmark UUID") @PathParam(value="bookmarkUUID") UUID bookmarkUUID) {
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such experiment").build();
        }
        IFile editorFile = TmfTraceManager.getInstance().getTraceEditorFile((ITmfTrace)experiment);
        if (editorFile == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Bookmark not found").build();
        }
        try {
            IMarker[] markers = BookmarkManagerService.findBookmarkMarkers(editorFile);
            IMarker marker = BookmarkManagerService.findMarkerByUUID(markers, bookmarkUUID);
            if (marker == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Bookmark not found").build();
            }
            Bookmark bookmark = BookmarkManagerService.markerToBookmark(marker);
            if (bookmark == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Bookmark not found").build();
            }
            return Response.ok((Object)bookmark).build();
        }
        catch (CoreException e) {
            Activator.getInstance().logError("Failed to get bookmark", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a new bookmark in an experiment", responses={@ApiResponse(responseCode="200", description="Bookmark created successfully", content={@Content(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Bookmark.class))}), @ApiResponse(responseCode="400", description="Invalid query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="No such experiment", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response createBookmark(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @RequestBody(content={@Content(schema=@Schema(implementation=BookmarkQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        if (queryParameters == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing query parameters").build();
        }
        Map<String, Object> parameters = queryParameters.getParameters();
        String errorMessage = QueryParametersUtil.validateBookmarkQueryParameters(parameters);
        if (errorMessage != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
        }
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such experiment").build();
        }
        IFile editorFile = TmfTraceManager.getInstance().getTraceEditorFile((ITmfTrace)experiment);
        if (editorFile == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Bookmark not found").build();
        }
        try {
            String name = Objects.requireNonNull((String)parameters.get(BOOKMARK_NAME));
            long start = Objects.requireNonNull((Number)parameters.get(BOOKMARK_START)).longValue();
            long end = Objects.requireNonNull((Number)parameters.get(BOOKMARK_END)).longValue();
            UUID uuid = BookmarkManagerService.generateUUID(editorFile);
            Bookmark bookmark = new Bookmark(uuid, name, start, end);
            IMarker marker = editorFile.createMarker("org.eclipse.core.resources.bookmark");
            BookmarkManagerService.setMarkerAttributes(marker, bookmark);
            return Response.ok((Object)bookmark).build();
        }
        catch (CoreException e) {
            Activator.getInstance().logError("Failed to create bookmark", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Path(value="/{bookmarkUUID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an existing bookmark in an experiment", responses={@ApiResponse(responseCode="200", description="Bookmark updated successfully", content={@Content(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Bookmark.class))}), @ApiResponse(responseCode="400", description="Invalid query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Experiment or bookmark not found", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response updateBookmark(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="Bookmark UUID") @PathParam(value="bookmarkUUID") UUID bookmarkUUID, @RequestBody(content={@Content(schema=@Schema(implementation=BookmarkQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        if (queryParameters == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing query parameters").build();
        }
        Map<String, Object> parameters = queryParameters.getParameters();
        String errorMessage = QueryParametersUtil.validateBookmarkQueryParameters(parameters);
        if (errorMessage != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
        }
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such experiment").build();
        }
        IFile editorFile = TmfTraceManager.getInstance().getTraceEditorFile((ITmfTrace)experiment);
        if (editorFile == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Bookmark not found").build();
        }
        String name = Objects.requireNonNull((String)parameters.get(BOOKMARK_NAME));
        long start = Objects.requireNonNull((Number)parameters.get(BOOKMARK_START)).longValue();
        long end = Objects.requireNonNull((Number)parameters.get(BOOKMARK_END)).longValue();
        Bookmark bookmark = new Bookmark(bookmarkUUID, name, start, end);
        try {
            IMarker[] markers = BookmarkManagerService.findBookmarkMarkers(editorFile);
            IMarker marker = BookmarkManagerService.findMarkerByUUID(markers, bookmarkUUID);
            if (marker == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Bookmark not found").build();
            }
            BookmarkManagerService.setMarkerAttributes(marker, bookmark);
            return Response.ok((Object)bookmark).build();
        }
        catch (CoreException e) {
            Activator.getInstance().logError("Failed to update bookmark", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{bookmarkUUID}")
    @Produces(value={"application/json"})
    @Operation(summary="Delete a bookmark from an experiment", responses={@ApiResponse(responseCode="200", description="Bookmark deleted successfully", content={@Content(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Bookmark.class))}), @ApiResponse(responseCode="404", description="Experiment or bookmark not found", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response deleteBookmark(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID, @Parameter(description="Bookmark UUID") @PathParam(value="bookmarkUUID") UUID bookmarkUUID) {
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such experiment").build();
        }
        IFile editorFile = TmfTraceManager.getInstance().getTraceEditorFile((ITmfTrace)experiment);
        if (editorFile == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Bookmark not found").build();
        }
        try {
            IMarker[] markers = BookmarkManagerService.findBookmarkMarkers(editorFile);
            IMarker marker = BookmarkManagerService.findMarkerByUUID(markers, bookmarkUUID);
            if (marker == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Bookmark not found").build();
            }
            Bookmark bookmark = BookmarkManagerService.markerToBookmark(marker);
            if (bookmark == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Bookmark not found").build();
            }
            marker.delete();
            return Response.ok((Object)bookmark).build();
        }
        catch (CoreException e) {
            Activator.getInstance().logError("Failed to delete bookmark", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private static UUID generateUUID(IFile editorFile) throws CoreException {
        UUID uuid;
        IMarker[] markers = BookmarkManagerService.findBookmarkMarkers(editorFile);
        while (BookmarkManagerService.findMarkerByUUID(markers, uuid = UUID.randomUUID()) != null) {
        }
        return uuid;
    }

    private static IMarker[] findBookmarkMarkers(IFile editorFile) throws CoreException {
        return editorFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
    }

    private static Bookmark markerToBookmark(IMarker marker) {
        long start;
        String uuid = marker.getAttribute(BOOKMARK_UUID, null);
        if (uuid == null) {
            return null;
        }
        String name = marker.getAttribute("message", null);
        if (name == null) {
            return null;
        }
        String startStr = marker.getAttribute("time", null);
        if (startStr == null) {
            return null;
        }
        try {
            start = Long.parseLong(startStr);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        long duration = 0L;
        String durationStr = marker.getAttribute("duration", null);
        if (durationStr != null) {
            try {
                duration = Long.parseLong(durationStr);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        long end = start + duration;
        return new Bookmark(UUID.fromString(uuid), name, start, end);
    }

    private static IMarker findMarkerByUUID(IMarker[] markers, UUID bookmarkUUID) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String uuid = marker.getAttribute(BOOKMARK_UUID, null);
            if (uuid != null && UUID.fromString(uuid).equals(bookmarkUUID)) {
                return marker;
            }
            ++n2;
        }
        return null;
    }

    private static void setMarkerAttributes(IMarker marker, Bookmark bookmark) throws CoreException {
        Long duration = bookmark.getEnd() - bookmark.getStart();
        marker.setAttribute(BOOKMARK_UUID, (Object)bookmark.getUUID().toString());
        marker.setAttribute("message", (Object)bookmark.getName());
        marker.setAttribute("time", (Object)Long.toString(bookmark.getStart()));
        if (duration > 0L) {
            marker.setAttribute("duration", (Object)Long.toString(duration));
            marker.setAttribute("location", (Object)NLS.bind((String)"timestamp [{0}, {1}]", (Object)TmfTimestamp.fromNanos((long)bookmark.getStart()), (Object)TmfTimestamp.fromNanos((long)bookmark.getEnd())));
        } else {
            marker.setAttribute("location", (Object)NLS.bind((String)"timestamp [{0}]", (Object)TmfTimestamp.fromNanos((long)bookmark.getStart())));
        }
        marker.setAttribute("color", (Object)BOOKMARK_DEFAULT_COLOR);
    }

    private static List<Bookmark> markersToBookmarks(IMarker[] markers) {
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            Bookmark bookmark = BookmarkManagerService.markerToBookmark(marker);
            if (bookmark != null) {
                bookmarks.add(bookmark);
            }
            ++n2;
        }
        return bookmarks;
    }
}

