/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.tracecompass.internal.tmf.remote.ui.messages.RemoteMessages;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.AbstractGenerateManifestOperation;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportConnectionNodeElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportFolderElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfileElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTraceFilesElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTraceGroupElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceCoreUtils;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;

public class RemoteGenerateManifestOperation
extends AbstractGenerateManifestOperation {
    private RemoteImportProfileElement fProfile;
    private Set<IPath> fDirectoryTraces = new HashSet<IPath>();

    public RemoteGenerateManifestOperation(RemoteImportProfileElement profile) {
        super(profile.getText());
        this.fProfile = profile;
    }

    public void run(IProgressMonitor monitor) {
        try {
            monitor.worked(1);
            String root = null;
            ArrayList<RemoteImportConnectionNodeElement> resultElementList = new ArrayList<RemoteImportConnectionNodeElement>();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.fProfile.getChildren().length * 2));
            List<RemoteImportConnectionNodeElement> connectionNodes = this.fProfile.getConnectionNodeElements();
            for (RemoteImportConnectionNodeElement connectionNode : connectionNodes) {
                RemoteSystemProxy proxy = connectionNode.getRemoteSystemProxy();
                RemoteImportConnectionNodeElement outputConnectionNode = new RemoteImportConnectionNodeElement(null, connectionNode.getName(), connectionNode.getURI());
                resultElementList.add(outputConnectionNode);
                TracePackageElement[] tracePackageElementArray = connectionNode.getChildren();
                int n = tracePackageElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TracePackageElement element = tracePackageElementArray[n2];
                    if (element instanceof RemoteImportTraceGroupElement) {
                        ModalContext.checkCanceled((IProgressMonitor)monitor);
                        RemoteImportTraceGroupElement traceGroup = (RemoteImportTraceGroupElement)element;
                        root = traceGroup.getRootImportPath();
                        TracePackageElement[] traceElements = traceGroup.getChildren();
                        this.fTemplatePatternsToTraceElements = this.generatePatterns(traceElements);
                        IRemoteFileService fs = (IRemoteFileService)proxy.getRemoteConnection().getService(IRemoteFileService.class);
                        if (fs != null) {
                            IFileStore remoteFolder = fs.getResource(root);
                            int recursionLevel = 0;
                            RemoteImportTraceGroupElement outputTraceGroup = new RemoteImportTraceGroupElement(outputConnectionNode, traceGroup.getRootImportPath());
                            outputTraceGroup.setRecursive(traceGroup.isRecursive());
                            this.generateElementsFromArchive(outputTraceGroup, outputTraceGroup, remoteFolder, recursionLevel, (IProgressMonitor)subMonitor.newChild(1));
                            this.filterElements(outputTraceGroup);
                        }
                    }
                    ++n2;
                }
            }
            this.setResultElements(resultElementList.toArray(new TracePackageElement[0]));
            this.setStatus(Status.OK_STATUS);
        }
        catch (InterruptedException interruptedException) {
            this.setStatus(Status.CANCEL_STATUS);
        }
        catch (Exception e) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.remote.ui", NLS.bind((String)RemoteMessages.RemoteGenerateManifest_GenerateProfileManifestError, (Object)this.fProfile.getText()), (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateElementsFromArchive(RemoteImportTraceGroupElement traceGroup, TracePackageElement parentElement, IFileStore traceFolder, int recursionLevel, IProgressMonitor monitor) throws CoreException, InterruptedException {
        int localRecursionLevel = recursionLevel + 1;
        IFileStore[] sources = traceFolder.childStores(0, monitor);
        int i = 0;
        while (i < sources.length) {
            block6: {
                IFileStore fileStore;
                SubMonitor subMonitor;
                block5: {
                    TracePackageElement parent;
                    String traceType;
                    IFileInfo sourceInfo;
                    Path fullArchivePath;
                    block8: {
                        block7: {
                            Map.Entry<Pattern, TracePackageTraceElement> matchingTemplateEntry;
                            ModalContext.checkCanceled((IProgressMonitor)monitor);
                            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)sources.length);
                            fileStore = sources[i];
                            fullArchivePath = TmfTraceCoreUtils.newSafePath((String)fileStore.toURI().getPath());
                            sourceInfo = fileStore.fetchInfo();
                            if (sourceInfo.isDirectory()) break block5;
                            String rootPathString = traceGroup.getRootImportPath();
                            Path rootPath = TmfTraceCoreUtils.newSafePath((String)rootPathString);
                            Path relativeTracePath = Path.EMPTY;
                            if (rootPath.isPrefixOf((IPath)fullArchivePath)) {
                                relativeTracePath = fullArchivePath.makeRelativeTo((IPath)rootPath);
                            }
                            if ((matchingTemplateEntry = this.getMatchingTemplateElement((IPath)relativeTracePath)) == null) break block6;
                            TracePackageTraceElement matchingTemplateElement = matchingTemplateEntry.getValue();
                            traceType = matchingTemplateElement.getTraceType();
                            parent = parentElement;
                            if (!this.matchesDirectoryTrace((IPath)relativeTracePath, matchingTemplateEntry)) break block7;
                            fullArchivePath = fullArchivePath.removeLastSegments(1);
                            this.fDirectoryTraces.add((IPath)fullArchivePath);
                            fileStore = fileStore.getParent();
                            sourceInfo = fileStore.fetchInfo();
                            parent = parentElement.getParent();
                            traceType = null;
                            break block8;
                        }
                        if (localRecursionLevel > 1 && !traceGroup.isRecursive()) break block6;
                    }
                    if (sourceInfo.getLength() > 0L || sourceInfo.isDirectory()) {
                        String traceName = fullArchivePath.lastSegment();
                        String fileName = fileStore.getName();
                        TracePackageTraceElement traceElement = new TracePackageTraceElement(parent, traceName, traceType);
                        RemoteImportTraceFilesElement tracePackageFilesElement = new RemoteImportTraceFilesElement((TracePackageElement)traceElement, fileName, fileStore);
                        tracePackageFilesElement.setVisible(false);
                    }
                    break block6;
                }
                if (traceGroup.isRecursive() || localRecursionLevel < 2) {
                    RemoteImportFolderElement folder = new RemoteImportFolderElement(parentElement, fileStore.getName());
                    this.generateElementsFromArchive(traceGroup, folder, fileStore, localRecursionLevel, (IProgressMonitor)subMonitor);
                }
            }
            ++i;
        }
    }

    private void filterElements(TracePackageElement parentElement) {
        TracePackageElement[] tracePackageElementArray = parentElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement childElement = tracePackageElementArray[n2];
            this.filterElements(childElement);
            if (childElement instanceof TracePackageTraceElement) {
                RemoteImportTraceFilesElement filesElement = (RemoteImportTraceFilesElement)childElement.getChildren()[0];
                IFileStore parentFile = filesElement.getRemoteFile().getParent();
                if (this.fDirectoryTraces.contains(TmfTraceCoreUtils.newSafePath((String)parentFile.toURI().getPath()))) {
                    RemoteGenerateManifestOperation.removeChild(childElement, parentElement);
                } else {
                    IFileStore grandParentFile = parentFile.getParent();
                    if (grandParentFile != null && this.fDirectoryTraces.contains(TmfTraceCoreUtils.newSafePath((String)grandParentFile.toURI().getPath()))) {
                        parentElement.removeChild(childElement);
                        if (parentElement.getChildren().length == 0) {
                            TracePackageElement grandParentElement = parentElement.getParent();
                            RemoteGenerateManifestOperation.removeChild(parentElement, grandParentElement);
                        }
                    }
                }
            } else if (childElement instanceof RemoteImportFolderElement && childElement.getChildren().length == 0) {
                parentElement.removeChild(childElement);
            }
            ++n2;
        }
    }

    private static void removeChild(TracePackageElement childElement, TracePackageElement parentElement) {
        parentElement.removeChild(childElement);
        if (parentElement.getChildren().length == 0 && parentElement.getParent() != null) {
            parentElement.getParent().removeChild(parentElement);
        }
    }

    @Override
    protected Map.Entry<Pattern, TracePackageTraceElement> getMatchingTemplateElement(IPath fullArchivePath) {
        for (Map.Entry<Pattern, TracePackageTraceElement> entry : this.fTemplatePatternsToTraceElements.entrySet()) {
            String traceType = ((TracePackageTraceElement)entry.getValue()).getTraceType();
            if ((traceType.isEmpty() || TmfTraceType.isDirectoryTraceType((String)traceType)) && this.matchesDirectoryTrace(fullArchivePath, entry)) {
                return entry;
            }
            if (!entry.getKey().matcher(TmfTraceCoreUtils.safePathToString((String)fullArchivePath.toString())).matches()) continue;
            return entry;
        }
        return null;
    }

    @Override
    protected boolean matchesDirectoryTrace(IPath archivePath, Map.Entry<Pattern, TracePackageTraceElement> entry) {
        if ("metadata".equals(archivePath.lastSegment())) {
            String traceType;
            IPath archiveParentPath = archivePath.removeLastSegments(1);
            String parentPathString = TmfTraceCoreUtils.safePathToString((String)archiveParentPath.toString());
            if (entry.getKey().matcher(parentPathString).matches() && ((traceType = entry.getValue().getTraceType()).isEmpty() || TmfTraceType.isDirectoryTraceType((String)traceType))) {
                return true;
            }
        }
        return false;
    }
}

