/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITraceContextSignalHandler;

@NonNullByDefault
public class TmfTraceContext
implements ITraceContextSignalHandler {
    static final TmfTraceContext NULL_CONTEXT = new TmfTraceContext(new TmfTimeRange(TmfTimestamp.BIG_CRUNCH, TmfTimestamp.BIG_CRUNCH), TmfTimeRange.NULL_RANGE, null, null);
    private final TmfTimeRange fSelection;
    private final TmfTimeRange fWindowRange;
    private final boolean fIsSynchronized;
    private final int fInstanceNumber;
    private final @Nullable IFile fEditorFile;
    private final @Nullable ITmfFilter fFilter;
    private final Map<@NonNull String, @NonNull Object> fData;

    public TmfTraceContext(TmfTimeRange selection, TmfTimeRange windowRange, @Nullable IFile editorFile, @Nullable ITmfFilter filter) {
        this.fSelection = selection;
        this.fWindowRange = windowRange;
        this.fIsSynchronized = false;
        this.fInstanceNumber = 1;
        this.fEditorFile = editorFile;
        this.fFilter = filter;
        this.fData = new HashMap<String, Object>();
    }

    public TmfTraceContext(Builder builder) {
        this.fSelection = builder.selection;
        this.fWindowRange = builder.windowRange;
        this.fIsSynchronized = builder.isSynchronized;
        this.fInstanceNumber = builder.instanceNumber;
        this.fEditorFile = builder.editorFile;
        this.fFilter = builder.filter;
        this.fData = new HashMap<String, Object>(builder.data);
    }

    public TmfTimeRange getSelectionRange() {
        return this.fSelection;
    }

    public TmfTimeRange getWindowRange() {
        return this.fWindowRange;
    }

    public boolean isSynchronized() {
        return this.fIsSynchronized;
    }

    public int getInstanceNumber() {
        return this.fInstanceNumber;
    }

    public @Nullable IFile getEditorFile() {
        return this.fEditorFile;
    }

    public @Nullable ITmfFilter getFilter() {
        return this.fFilter;
    }

    public synchronized @Nullable Object getData(String key) {
        return this.fData.get(key);
    }

    public synchronized Map<String, Object> getData() {
        return ImmutableMap.copyOf(this.fData);
    }

    public Builder builder() {
        return new Builder(this);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[fSelection=" + this.fSelection + ", fWindowRange=" + this.fWindowRange + ']';
    }

    public static class Builder {
        private TmfTimeRange selection;
        private TmfTimeRange windowRange;
        private boolean isSynchronized;
        private int instanceNumber;
        private @Nullable IFile editorFile;
        private @Nullable ITmfFilter filter;
        private Map<String, Object> data;

        public Builder(TmfTraceContext ctx) {
            this.selection = ctx.fSelection;
            this.windowRange = ctx.fWindowRange;
            this.isSynchronized = ctx.fIsSynchronized;
            this.instanceNumber = ctx.fInstanceNumber;
            this.editorFile = ctx.fEditorFile;
            this.filter = ctx.fFilter;
            this.data = new HashMap<String, Object>(ctx.fData);
        }

        public TmfTraceContext build() {
            return new TmfTraceContext(this);
        }

        public Builder setSelection(TmfTimeRange selection) {
            this.selection = selection;
            return this;
        }

        public Builder setWindowRange(TmfTimeRange windowRange) {
            this.windowRange = windowRange;
            return this;
        }

        public Builder setSynchronized(boolean isSynchronized) {
            this.isSynchronized = isSynchronized;
            return this;
        }

        Builder setInstanceNumber(int instanceNumber) {
            this.instanceNumber = instanceNumber;
            return this;
        }

        public Builder setFilter(@Nullable ITmfFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder setData(String key, @Nullable Object value) {
            if (value == null) {
                this.data.remove(key);
                return this;
            }
            this.data.put(key, value);
            return this;
        }

        public Builder setData(Map<String, Object> data) {
            this.data.putAll(data);
            return this;
        }
    }
}

