/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.scripting.core.trace;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.scripting.core.trace.Messages;
import org.eclipse.tracecompass.incubator.internal.scripting.core.trace.ScriptEventRequest;
import org.eclipse.tracecompass.incubator.scripting.core.trace.ScriptEventsIterator;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class TraceScriptingModule
extends AbstractScriptModule {
    @Deprecated
    @WrapToScript
    public ITmfTrace openTrace(String projectName, String traceName, @ScriptParameter(defaultValue="false") boolean isExperiment) {
        throw new UnsupportedOperationException("Load the /TraceCompass/TraceUI module instead");
    }

    @WrapToScript
    public @Nullable ITmfTrace openMinimalTrace(String projectName, String traceName, @ScriptParameter(defaultValue="false") boolean isExperiment) throws FileNotFoundException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            throw new FileNotFoundException(Messages.projectDoesNotExist);
        }
        String folderName = isExperiment ? "Experiments" : "Traces";
        IFolder subFolder = project.getFolder(folderName);
        if (!subFolder.exists()) {
            throw new FileNotFoundException(Messages.folderDoesNotExist);
        }
        String[] split = traceName.split("/");
        int i = 0;
        while (i <= split.length - 2) {
            if (!(subFolder = subFolder.getFolder(split[i])).exists()) {
                throw new FileNotFoundException(Messages.folderDoesNotExist);
            }
            ++i;
        }
        String traceFile = split[split.length - 1];
        IFile file = subFolder.getFile(traceFile);
        IPath location = file.getLocation();
        if (location == null) {
            return null;
        }
        try {
            String traceFileName = location.toFile().getName();
            return TraceScriptingModule.openAndInitializeTrace(file, Objects.requireNonNull(location.toOSString()), traceFileName, "");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | TmfTraceException | TmfTraceImportException throwable) {
            throw new FileNotFoundException(Messages.traceDoesNotExist);
        }
    }

    private static ITmfTrace openAndInitializeTrace(IFile file, String location, String name, String typeID) throws TmfTraceException, InstantiationException, IllegalAccessException, FileNotFoundException, TmfTraceImportException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        List traceTypes = TmfTraceType.selectTraceType((String)location, (String)typeID);
        if (traceTypes.isEmpty()) {
            throw new FileNotFoundException(Messages.noTraceType);
        }
        TraceTypeHelper helper = (TraceTypeHelper)traceTypes.get(0);
        ITmfTrace trace = (ITmfTrace)helper.getTraceClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        trace.initTrace((IResource)file, location, ITmfEvent.class, name, typeID);
        return trace;
    }

    @WrapToScript
    public @Nullable ITmfTrace getActiveTrace() {
        return TmfTraceManager.getInstance().getActiveTrace();
    }

    @WrapToScript
    public ScriptEventsIterator getEventIterator(@Nullable ITmfTrace trace) {
        if (trace == null) {
            throw new NullPointerException("Trace should not be null");
        }
        ScriptEventRequest scriptEventRequest = new ScriptEventRequest();
        trace.sendRequest((ITmfEventRequest)scriptEventRequest);
        this.setupEventIteratorExecutionListener(scriptEventRequest);
        return scriptEventRequest.getEventIterator();
    }

    private void setupEventIteratorExecutionListener(final ScriptEventRequest scriptEventRequest) {
        IScriptEngine scriptEngine = this.getScriptEngine();
        if (scriptEngine == null) {
            return;
        }
        scriptEngine.addExecutionListener(new IExecutionListener(){

            public void notify(@Nullable IScriptEngine engine, @Nullable Script script, int status) {
                if (status == 4 && !scriptEventRequest.isCompleted()) {
                    scriptEventRequest.cancel();
                }
            }
        });
    }

    @WrapToScript
    public @Nullable Object getEventFieldValue(ITmfEvent event, String fieldName) {
        ITmfEventField field = event.getContent().getField(new String[]{fieldName});
        if (field == null) {
            return TmfTraceUtils.resolveAspectOfNameForEvent((ITmfTrace)event.getTrace(), (String)fieldName, (ITmfEvent)event);
        }
        return field.getValue();
    }
}

