/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph;

import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.analysis.timing.core.statistics.Statistics;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public class AggregatedCalledFunctionStatistics {
    private final IStatistics<ICalledFunction> fDurations = new Statistics(ISegment::getLength);
    private final IStatistics<ICalledFunction> fSelfTimes = new Statistics(ICalledFunction::getSelfTime);

    public void update(ICalledFunction function) {
        this.fDurations.update((Object)function);
        this.fSelfTimes.update((Object)function);
    }

    public void merge(AggregatedCalledFunctionStatistics statisticsNode) {
        this.fDurations.merge(statisticsNode.fDurations);
        this.fSelfTimes.merge(statisticsNode.fSelfTimes);
    }

    public IStatistics<ICalledFunction> getDurationStatistics() {
        return this.fDurations;
    }

    public IStatistics<ICalledFunction> getSelfTimeStatistics() {
        return this.fSelfTimes;
    }

    public String toString() {
        return "Aggregated function statistics: Durations: " + this.fDurations + ", Self times " + this.fSelfTimes;
    }
}

