/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.context;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class ContextStateProvider
extends AbstractTmfStateProvider {
    private static final Set<String> ACCEPTED = ImmutableSet.of((Object)"(", (Object)")");

    public ContextStateProvider(@NonNull ITmfTrace trace) {
        super(trace, "org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.context");
    }

    public int getVersion() {
        return 1;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new ContextStateProvider(this.getTrace());
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        ITmfStateSystemBuilder ss = this.getStateSystemBuilder();
        long t = event.getTimestamp().toNanos();
        String phase = (String)event.getContent().getFieldValue(String.class, new String[]{"ph"});
        if (ss == null || !ACCEPTED.contains(phase)) {
            return;
        }
        String catField = (String)event.getContent().getFieldValue(String.class, new String[]{"cat"});
        String nameField = (String)event.getContent().getFieldValue(String.class, new String[]{"name"});
        String idField = (String)event.getContent().getFieldValue(String.class, new String[]{"id"});
        int quark = ss.getQuarkAbsoluteAndAdd(new String[]{catField, nameField, idField});
        if (Objects.equals(phase, "(")) {
            ss.modifyAttribute(t, (Object)1, quark);
        }
        if (Objects.equals(phase, ")")) {
            ss.modifyAttribute(t, null, quark);
        }
    }
}

