/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.io.IOException;
import org.apache.lucene.analysis.GraphTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public final class FixedShingleFilter
extends GraphTokenFilter {
    private static final int MAX_SHINGLE_SIZE = 4;
    private final int shingleSize;
    private final String tokenSeparator;
    private final String fillerToken;
    private final PositionIncrementAttribute incAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final CharTermAttribute buffer = new CharTermAttributeImpl();

    public FixedShingleFilter(TokenStream input, int shingleSize) {
        this(input, shingleSize, " ", "_");
    }

    public FixedShingleFilter(TokenStream input, int shingleSize, String tokenSeparator, String fillerToken) {
        super(input);
        if (shingleSize <= 1 || shingleSize > 4) {
            throw new IllegalArgumentException("Shingle size must be between 2 and 4, got " + shingleSize);
        }
        this.shingleSize = shingleSize;
        this.tokenSeparator = tokenSeparator;
        this.fillerToken = fillerToken;
    }

    public boolean incrementToken() throws IOException {
        int shinglePosInc;
        if (!this.incrementGraph()) {
            if (!this.incrementBaseToken()) {
                return false;
            }
            shinglePosInc = this.incAtt.getPositionIncrement();
        } else {
            shinglePosInc = 0;
        }
        int startOffset = this.offsetAtt.startOffset();
        int endOffset = this.offsetAtt.endOffset();
        this.buffer.setEmpty();
        this.buffer.append(this.termAtt);
        for (int i = 1; i < this.shingleSize; ++i) {
            if (!this.incrementGraphToken()) {
                int trailingPositions = this.getTrailingPositions();
                if (i + trailingPositions < this.shingleSize) {
                    return false;
                }
                while (i < this.shingleSize) {
                    this.buffer.append(this.tokenSeparator).append(this.fillerToken);
                    ++i;
                }
                break;
            }
            int posInc = this.incAtt.getPositionIncrement();
            if (posInc > 1) {
                if (i + posInc > this.shingleSize) {
                    while (i < this.shingleSize) {
                        this.buffer.append(this.tokenSeparator).append(this.fillerToken);
                        ++i;
                    }
                    break;
                }
                while (posInc > 1) {
                    this.buffer.append(this.tokenSeparator).append(this.fillerToken);
                    --posInc;
                    ++i;
                }
            }
            this.buffer.append(this.tokenSeparator).append(this.termAtt);
            endOffset = this.offsetAtt.endOffset();
        }
        this.clearAttributes();
        this.offsetAtt.setOffset(startOffset, endOffset);
        this.incAtt.setPositionIncrement(shinglePosInc);
        this.termAtt.setEmpty().append(this.buffer);
        this.typeAtt.setType("shingle");
        return true;
    }
}

