/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionControlService;
import org.eclipse.remote.core.IRemoteConnectionPropertyService;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.core.RemoteConnection;
import org.eclipse.remote.internal.core.RemoteConnectionType;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class RemoteConnectionWorkingCopy
implements IRemoteConnectionWorkingCopy {
    private RemoteConnection original;
    private final RemoteConnectionType connectionType;
    private String newName;
    private final Map<String, String> newAttributes = new HashMap<String, String>();
    private final Map<String, String> newSecureAttributes = new HashMap<String, String>();
    private final List<IRemoteConnectionChangeListener> newListeners = new ArrayList<IRemoteConnectionChangeListener>();

    public RemoteConnectionWorkingCopy(RemoteConnectionType connectionType, String name) {
        this.connectionType = connectionType;
        this.newName = name;
    }

    public RemoteConnectionWorkingCopy(RemoteConnection original) {
        this.original = original;
        this.connectionType = (RemoteConnectionType)original.getConnectionType();
    }

    @Override
    public String getName() {
        if (this.newName != null) {
            return this.newName;
        }
        if (this.original != null) {
            return this.original.getName();
        }
        return null;
    }

    @Override
    public void setName(String name) {
        if (this.original == null || !name.equals(this.original.getName())) {
            this.newName = name;
        }
    }

    @Override
    public String getAttribute(String key) {
        String value = this.newAttributes.get(key);
        if (value != null) {
            return value;
        }
        if (this.original != null) {
            return this.original.getAttribute(key);
        }
        return "";
    }

    @Override
    public void setAttribute(String key, String value) {
        if (this.original == null || value == null || !value.equals(this.original.getAttribute(key))) {
            this.newAttributes.put(key, value);
        }
    }

    @Override
    public String getSecureAttribute(String key) {
        String value = this.newSecureAttributes.get(key);
        if (value != null) {
            return value;
        }
        if (this.original != null) {
            return this.original.getSecureAttribute(key);
        }
        return "";
    }

    @Override
    public void setSecureAttribute(String key, String value) {
        if (this.original == null || value == null || !value.equals(this.original.getSecureAttribute(key))) {
            this.newSecureAttributes.put(key, value);
        }
    }

    @Override
    public void addConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        if (this.original != null) {
            this.original.addConnectionChangeListener(listener);
        } else {
            this.newListeners.add(listener);
        }
    }

    @Override
    public void removeConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        if (this.original != null) {
            this.original.removeConnectionChangeListener(listener);
        } else {
            this.newListeners.remove(listener);
        }
    }

    @Override
    public void fireConnectionChangeEvent(int type) {
        if (this.original != null && type != 8) {
            this.original.fireConnectionChangeEvent(type);
        } else {
            RemoteConnectionChangeEvent event = new RemoteConnectionChangeEvent(this, type);
            for (IRemoteConnectionChangeListener listener : this.newListeners) {
                listener.connectionChanged(event);
            }
            this.connectionType.getRemoteServicesManager().fireRemoteConnectionChangeEvent(event);
        }
    }

    @Override
    public IRemoteConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Override
    public IRemoteConnectionWorkingCopy getWorkingCopy() {
        return this;
    }

    @Override
    public <T extends IRemoteConnection.Service> T getService(Class<T> service) {
        return this.connectionType.getConnectionService(this, service);
    }

    @Override
    public <T extends IRemoteConnection.Service> boolean hasService(Class<T> service) {
        if (this.original != null) {
            return this.original.hasService(service);
        }
        return this.connectionType.hasConnectionService(service);
    }

    @Override
    public IRemoteConnection getOriginal() {
        return this.original;
    }

    @Override
    public boolean isDirty() {
        return this.newName != null || !this.newAttributes.isEmpty() || !this.newSecureAttributes.isEmpty();
    }

    @Override
    public IRemoteConnection save() throws RemoteConnectionException {
        if (this.newName != null && this.original != null) {
            this.fireConnectionChangeEvent(8);
            this.connectionType.removeConnection(this.original.getName());
            this.original.rename(this.newName);
        }
        boolean added = false;
        if (this.original == null) {
            this.original = new RemoteConnection(this.connectionType, this.newName);
            added = true;
        }
        Preferences prefs = this.original.getPreferences();
        for (Map.Entry<String, String> entry : this.newAttributes.entrySet()) {
            String value = entry.getValue();
            if (value != null && !value.isEmpty()) {
                prefs.put(entry.getKey(), value);
                continue;
            }
            prefs.remove(entry.getKey());
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e1) {
            throw new RemoteConnectionException(e1);
        }
        ISecurePreferences securePrefs = this.original.getSecurePreferences();
        for (Map.Entry<String, String> entry : this.newSecureAttributes.entrySet()) {
            String value = entry.getValue();
            if (value != null && !value.isEmpty()) {
                try {
                    securePrefs.put(entry.getKey(), value, true);
                    continue;
                }
                catch (StorageException e) {
                    throw new RemoteConnectionException(e);
                }
            }
            securePrefs.remove(entry.getKey());
        }
        try {
            securePrefs.flush();
        }
        catch (IOException e) {
            throw new RemoteConnectionException(e);
        }
        if (this.newAttributes.size() > 0 || this.newSecureAttributes.size() > 0) {
            this.original.fireConnectionChangeEvent(64);
        }
        this.newAttributes.clear();
        this.newSecureAttributes.clear();
        this.newName = null;
        this.connectionType.addConnection(this.original);
        if (added) {
            this.original.fireConnectionChangeEvent(16);
        }
        return this.original;
    }

    @Override
    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        if (this.original != null) {
            this.original.open(monitor);
        } else {
            IRemoteConnectionControlService controlService = this.connectionType.getConnectionService(this, IRemoteConnectionControlService.class);
            if (controlService != null) {
                controlService.open(monitor);
            }
        }
    }

    @Override
    public void close() {
        if (this.original != null) {
            this.original.close();
        } else {
            IRemoteConnectionControlService controlService = this.connectionType.getConnectionService(this, IRemoteConnectionControlService.class);
            if (controlService != null) {
                controlService.close();
            }
        }
    }

    @Override
    public boolean isOpen() {
        if (this.original != null) {
            return this.original.isOpen();
        }
        IRemoteConnectionControlService controlService = this.connectionType.getConnectionService(this, IRemoteConnectionControlService.class);
        if (controlService != null) {
            return controlService.isOpen();
        }
        return true;
    }

    @Override
    public String getProperty(String key) {
        if (this.original != null) {
            return this.original.getProperty(key);
        }
        IRemoteConnectionPropertyService propertyService = this.connectionType.getConnectionService(this, IRemoteConnectionPropertyService.class);
        if (propertyService != null) {
            return propertyService.getProperty(key);
        }
        return null;
    }
}

