/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.CallGraph;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.AggregatedThreadStatus;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.FlamegraphDepthEntry;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.FlamegraphEvent;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.Messages;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.SortOption;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.ThreadIdComparator;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph.ThreadNameComparator;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class FlameGraphContentProvider
implements ITimeGraphContentProvider {
    private final List<TimeGraphEntry> fFlameGraphEntries = new ArrayList<TimeGraphEntry>();
    private SortOption fSortOption = SortOption.BY_NAME;
    private Comparator<TimeGraphEntry> fThreadComparator = new ThreadNameComparator();
    private final Map<ICallStackElement, TimeGraphEntry> fLevelEntries = new HashMap<ICallStackElement, TimeGraphEntry>();

    private void setData(AggregatedCallSite firstNode, List<FlamegraphDepthEntry> childrenEntries, Deque<Long> timestampStack) {
        Long lastEnd = timestampStack.peek();
        if (lastEnd == null) {
            return;
        }
        int i = 0;
        while (i <= firstNode.getMaxDepth() - 1) {
            if (i >= childrenEntries.size()) {
                FlamegraphDepthEntry entry = new FlamegraphDepthEntry(String.valueOf(i), 0L, firstNode.getWeight(), i, String.valueOf(i));
                childrenEntries.add(entry);
            }
            childrenEntries.get(i).updateEndTime(lastEnd + firstNode.getWeight());
            ++i;
        }
        FlamegraphDepthEntry firstEntry = (FlamegraphDepthEntry)((Object)NonNullUtils.checkNotNull((Object)((Object)childrenEntries.get(0))));
        firstEntry.addEvent((ITimeEvent)new FlamegraphEvent((ITimeGraphEntry)firstEntry, lastEnd, firstNode));
        this.addEvent(firstNode, childrenEntries, timestampStack, 1);
        timestampStack.pop();
    }

    private static void setExtraData(AggregatedCallSite firstNode, List<TimeGraphEntry> extraEntries, Deque<Long> timestampStack) {
        TimeGraphEntry entry;
        Long lastEnd = timestampStack.peek();
        if (lastEnd == null) {
            return;
        }
        Iterator extraChildrenSites = firstNode.getExtraChildrenSites().iterator();
        if (!extraChildrenSites.hasNext()) {
            return;
        }
        if (extraEntries.isEmpty()) {
            entry = new TimeGraphEntry(Messages.FlameGraphContentProvider_EntryName, 0L, 0L);
            extraEntries.add(entry);
        }
        entry = extraEntries.get(0);
        while (extraChildrenSites.hasNext()) {
            AggregatedCallSite next = (AggregatedCallSite)extraChildrenSites.next();
            if (next instanceof AggregatedThreadStatus) {
                entry.addEvent((ITimeEvent)new TimeEvent((ITimeGraphEntry)entry, lastEnd.longValue(), next.getWeight(), ((AggregatedThreadStatus)next).getProcessStatus().getStateValue().unboxInt()));
            } else {
                entry.addEvent((ITimeEvent)new FlamegraphEvent((ITimeGraphEntry)entry, lastEnd, next));
            }
            lastEnd = lastEnd + next.getWeight();
            entry.updateEndTime(lastEnd.longValue());
        }
    }

    private void addEvent(AggregatedCallSite node, List<FlamegraphDepthEntry> childrenEntries, Deque<Long> timestampStack, int depth) {
        node.getCallees().stream().sorted(Comparator.comparingLong(WeightedTree::getWeight)).forEach(child -> this.addEvent((AggregatedCallSite)child, childrenEntries, timestampStack, depth + 1));
        node.getCallees().stream().forEach(child -> timestampStack.pop());
        Long lastEnd = timestampStack.peek();
        if (lastEnd == null) {
            return;
        }
        FlamegraphDepthEntry entry = (FlamegraphDepthEntry)((Object)NonNullUtils.checkNotNull((Object)((Object)childrenEntries.get(depth - 1))));
        entry.addEvent((ITimeEvent)new FlamegraphEvent((ITimeGraphEntry)entry, lastEnd, node));
        timestampStack.push(lastEnd + node.getWeight());
    }

    public boolean hasChildren(@Nullable Object element) {
        return !this.fFlameGraphEntries.isEmpty();
    }

    public ITimeGraphEntry[] getElements(@Nullable Object inputElement) {
        this.fFlameGraphEntries.clear();
        this.fLevelEntries.clear();
        if (inputElement instanceof Collection) {
            Collection callgraphProviders = (Collection)inputElement;
            for (Object object : callgraphProviders) {
                if (!(object instanceof CallGraph)) continue;
                this.buildCallGraph((CallGraph)object);
            }
        } else {
            return new ITimeGraphEntry[0];
        }
        this.fFlameGraphEntries.sort(this.fThreadComparator);
        return this.fFlameGraphEntries.toArray(new ITimeGraphEntry[this.fFlameGraphEntries.size()]);
    }

    private void buildCallGraph(CallGraph object) {
        Collection elements = object.getElements();
        for (ICallStackElement element : elements) {
            this.buildChildrenEntries(element, object, null);
        }
    }

    private void buildChildrenEntries(ICallStackElement element, CallGraph object, @Nullable TimeGraphEntry parent) {
        TimeGraphEntry currentEntry = new TimeGraphEntry(element.getName(), 0L, 0L);
        if (parent != null) {
            parent.addChild(currentEntry);
        } else {
            this.fFlameGraphEntries.add(currentEntry);
        }
        for (ICallStackElement child2 : element.getChildrenElements()) {
            this.buildChildrenEntries(child2, object, currentEntry);
        }
        if (!element.isLeaf()) {
            return;
        }
        ArrayList childrenEntries = new ArrayList();
        ArrayList extraEntries = new ArrayList();
        ArrayDeque<Long> timestampStack = new ArrayDeque<Long>();
        timestampStack.push(0L);
        object.getCallingContextTree(element).stream().sorted(Comparator.comparingLong(WeightedTree::getWeight)).forEach(rootFunction -> {
            this.setData((AggregatedCallSite)rootFunction, childrenEntries, (Deque<Long>)timestampStack);
            FlameGraphContentProvider.setExtraData(rootFunction, extraEntries, timestampStack);
            long currentThreadDuration = (Long)timestampStack.pop() + rootFunction.getWeight();
            timestampStack.push(currentThreadDuration);
        });
        childrenEntries.forEach(child -> currentEntry.addChild((TimeGraphEntry)child));
        extraEntries.forEach(child -> currentEntry.addChild(child));
        currentEntry.updateEndTime(((Long)timestampStack.pop()).longValue());
    }

    public ITimeGraphEntry[] getChildren(@Nullable Object parentElement) {
        return (ITimeGraphEntry[])this.fFlameGraphEntries.toArray(new TimeGraphEntry[this.fFlameGraphEntries.size()]);
    }

    public @Nullable ITimeGraphEntry getParent(@Nullable Object element) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(@Nullable Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
    }

    public SortOption getSortOption() {
        return this.fSortOption;
    }

    public void setSortOption(SortOption sortOption) {
        this.fSortOption = sortOption;
        switch (sortOption) {
            case BY_NAME: {
                this.fThreadComparator = new ThreadNameComparator();
                break;
            }
            case BY_NAME_REV: {
                this.fThreadComparator = (Comparator)NonNullUtils.checkNotNull(new ThreadNameComparator().reversed());
                break;
            }
            case BY_ID: {
                this.fThreadComparator = new ThreadIdComparator();
                break;
            }
            case BY_ID_REV: {
                this.fThreadComparator = (Comparator)NonNullUtils.checkNotNull(new ThreadIdComparator().reversed());
                break;
            }
        }
    }
}

