/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapterFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManagerListener;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDescriptionBuilder;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.tabletree.TreeContentHelper;
import org.eclipse.wst.xml.ui.internal.util.SharedXMLEditorPluginImageHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLTableTreeContentProvider
implements ITreeContentProvider,
ITableLabelProvider,
ITableColorProvider,
ILabelProvider,
CMDocumentManagerListener {
    protected CMDocumentManager documentManager;
    StructuredViewer fViewer = null;
    private TreeContentHelper treeContentHelper = new TreeContentHelper();
    private CMDescriptionBuilder descriptionBuilder = new CMDescriptionBuilder();
    private Color fCMColor = null;
    static /* synthetic */ Class class$0;

    public void addListener(ILabelProviderListener listener) {
    }

    public void cacheCleared(CMDocumentCache cache) {
        this.doDelayedRefreshForViewers();
    }

    public void cacheUpdated(CMDocumentCache cache, String uri, int oldStatus, int newStatus, CMDocument cmDocument) {
        if (newStatus == 3 || newStatus == 4) {
            this.doDelayedRefreshForViewers();
        }
    }

    public void dispose() {
        if (this.documentManager != null) {
            this.documentManager.removeListener((CMDocumentManagerListener)this);
        }
        if (this.fViewer != null && this.fViewer.getInput() != null && this.fViewer.getInput() instanceof IDOMNode) {
            IJFaceNodeAdapterFactory factory;
            FactoryRegistry factoryRegistry = ((IDOMNode)this.fViewer.getInput()).getModel().getFactoryRegistry();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((factory = (IJFaceNodeAdapterFactory)factoryRegistry.getFactoryFor((Object)clazz)) != null) {
                factory.removeListener((Object)this.fViewer);
            }
        }
        if (this.fCMColor != null) {
            this.fCMColor.dispose();
        }
    }

    private void doDelayedRefreshForViewers() {
        if (this.fViewer != null && !this.fViewer.getControl().isDisposed()) {
            this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (XMLTableTreeContentProvider.this.fViewer != null && !XMLTableTreeContentProvider.this.fViewer.getControl().isDisposed()) {
                        XMLTableTreeContentProvider.this.fViewer.refresh(true);
                    }
                }
            });
        }
    }

    public Object[] getChildren(Object element) {
        if (element instanceof INodeNotifier) {
            INodeNotifier iNodeNotifier = (INodeNotifier)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iNodeNotifier.getAdapterFor((Object)clazz);
        }
        return this.treeContentHelper.getChildren(element);
    }

    public Image getColumnImage(Object object, int columnIndex) {
        return columnIndex == 0 ? this.getImage(object) : null;
    }

    public String getColumnText(Object object, int column) {
        String result = null;
        if (column == 0) {
            result = this.getText(object);
        } else if (column == 1 && object instanceof Node && (result = this.treeContentHelper.getNodeValue((Node)object)) == null) {
            result = this.getElementValueHelper((Element)object);
        }
        result = TextProcessor.process((String)result);
        return result != null ? result : "";
    }

    private String getElementValueHelper(Element element) {
        CMElementDeclaration ed;
        String result = null;
        ModelQuery mq = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        if (result == null && mq != null && (ed = mq.getCMElementDeclaration(element)) != null && !Boolean.TRUE.equals(ed.getProperty("isInferred"))) {
            result = this.descriptionBuilder.buildDescription((CMNode)ed);
        }
        return result != null ? result : "";
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Image getImage(Object object) {
        if (object instanceof INodeNotifier) {
            INodeNotifier iNodeNotifier = (INodeNotifier)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iNodeNotifier.getAdapterFor((Object)clazz);
        }
        Image image = null;
        if (object instanceof Node) {
            Node node = (Node)object;
            switch (node.getNodeType()) {
                case 2: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/attribute_obj.gif");
                    break;
                }
                case 4: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/cdatasection.gif");
                    break;
                }
                case 8: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/comment_obj.gif");
                    break;
                }
                case 10: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/doctype.gif");
                    break;
                }
                case 1: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/element_obj.gif");
                    break;
                }
                case 7: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/proinst_obj.gif");
                    break;
                }
                case 3: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/text.gif");
                    break;
                }
                case 5: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/entity_reference.gif");
                }
            }
        }
        return image;
    }

    public Object getParent(Object o) {
        if (o instanceof INodeNotifier) {
            INodeNotifier iNodeNotifier = (INodeNotifier)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iNodeNotifier.getAdapterFor((Object)clazz);
        }
        Node result = null;
        if (o instanceof Node) {
            Node node = (Node)o;
            result = node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode();
        }
        return result;
    }

    public Element getRootElement(Document document) {
        Element rootElement = null;
        Node childNode = document.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeType() == 1) {
                rootElement = (Element)childNode;
                break;
            }
            childNode = childNode.getNextSibling();
        }
        return rootElement;
    }

    public String getText(Object object) {
        if (object instanceof INodeNotifier) {
            INodeNotifier iNodeNotifier = (INodeNotifier)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iNodeNotifier.getAdapterFor((Object)clazz);
        }
        String result = null;
        if (object instanceof Node) {
            Node node = (Node)object;
            switch (node.getNodeType()) {
                case 2: {
                    result = node.getNodeName();
                    break;
                }
                case 10: {
                    result = "DOCTYPE";
                    break;
                }
                case 1: {
                    result = node.getNodeName();
                    break;
                }
                case 7: {
                    result = ((ProcessingInstruction)node).getTarget();
                }
            }
        }
        return (result = TextProcessor.process(result)) != null ? result : "";
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IJFaceNodeAdapterFactory factory;
        Document domDoc;
        ModelQuery mq;
        if (oldInput != null && (mq = ModelQueryUtil.getModelQuery((Document)(domDoc = (Document)oldInput))) != null) {
            this.documentManager = mq.getCMDocumentManager();
            if (this.documentManager != null) {
                this.documentManager.removeListener((CMDocumentManagerListener)this);
            }
        }
        if (oldInput != null && oldInput instanceof IDOMNode) {
            FactoryRegistry factoryRegistry = ((IDOMNode)oldInput).getModel().getFactoryRegistry();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((factory = (IJFaceNodeAdapterFactory)factoryRegistry.getFactoryFor((Object)clazz)) != null) {
                factory.removeListener((Object)viewer);
            }
        }
        this.fViewer = viewer instanceof StructuredViewer ? null : (StructuredViewer)viewer;
        if (newInput != null && newInput instanceof IDOMNode) {
            FactoryRegistry factoryRegistry = ((IDOMNode)newInput).getModel().getFactoryRegistry();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((factory = (IJFaceNodeAdapterFactory)factoryRegistry.getFactoryFor((Object)clazz)) != null) {
                factory.addListener((Object)viewer);
            }
        }
        if (newInput != null && (mq = ModelQueryUtil.getModelQuery((Document)(domDoc = (Document)newInput))) != null) {
            this.documentManager = mq.getCMDocumentManager();
            if (this.documentManager != null) {
                this.documentManager.setPropertyEnabled("asyncLoad", true);
                this.documentManager.addListener((CMDocumentManagerListener)this);
            }
        }
    }

    public boolean isDeleted(Object element) {
        return element != null;
    }

    public boolean isIgnorableText(Node node) {
        boolean result = false;
        try {
            if (node.getNodeType() == 3) {
                String data = ((Text)node).getData();
                result = data == null || data.trim().length() == 0;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return result;
    }

    public boolean isLabelProperty(Object object, String property) {
        return false;
    }

    public void propertyChanged(CMDocumentManager cmDocumentManager, String propertyName) {
        if (cmDocumentManager.getPropertyEnabled("autoLoad")) {
            this.doDelayedRefreshForViewers();
        }
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (columnIndex == 1 && this.treeContentHelper.getNodeValue((Node)element) == null) {
            return this.getCMColor();
        }
        return null;
    }

    private Color getCMColor() {
        if (this.fCMColor == null) {
            Color background = Display.getCurrent().getSystemColor(25);
            int r = Math.abs(background.getRed() - 125);
            int g = Math.abs(background.getGreen() - 85);
            int b = Math.abs(background.getBlue() - 105);
            this.fCMColor = new Color((Device)Display.getCurrent(), r, g, b);
        }
        return this.fCMColor;
    }
}

