/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.contextswitch.ui.view;

import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

class ContextSwitchTimeEvent
extends TimeEvent {
    public ContextSwitchRate fRate = ContextSwitchRate.NONE;
    private int fCount;

    public ContextSwitchTimeEvent(ITimeGraphEntry entry, long time, long duration, int value) {
        this(entry, time, duration, value, 1);
    }

    public ContextSwitchTimeEvent(ITimeGraphEntry entry, long time, long duration, int value, int count) {
        super(entry, time, duration, value);
        this.fCount = count;
    }

    public ITimeEvent splitBefore(long splitTime) {
        ContextSwitchTimeEvent event;
        ContextSwitchTimeEvent contextSwitchTimeEvent = event = splitTime > this.fTime ? new ContextSwitchTimeEvent(this.fEntry, this.fTime, Math.min(this.fDuration, splitTime - this.fTime), this.getValue()) : null;
        if (event != null) {
            event.fRate = this.fRate;
        }
        return event;
    }

    public ITimeEvent splitAfter(long splitTime) {
        ContextSwitchTimeEvent event;
        ContextSwitchTimeEvent contextSwitchTimeEvent = event = splitTime < this.fTime + this.fDuration ? new ContextSwitchTimeEvent(this.fEntry, Math.max(this.fTime, splitTime), this.fDuration - Math.max(0L, splitTime - this.fTime), this.getValue()) : null;
        if (event != null) {
            event.fRate = this.fRate;
        }
        return event;
    }

    public int getCount() {
        return this.fCount;
    }

    public static enum ContextSwitchRate {
        NONE,
        LOW,
        MODERATE,
        HIGH,
        CRITICAL;

    }
}

