/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.internal.genericeditor.TextHoverRegistry;

class OrderedExtensionComparator
implements Comparator<TextHoverRegistry.TextHoverExtension> {
    private Map<String, TextHoverRegistry.TextHoverExtension> extensionsById;

    public OrderedExtensionComparator(Collection<TextHoverRegistry.TextHoverExtension> extensions) {
        Assert.isNotNull(extensions);
        this.extensionsById = extensions.stream().collect(Collectors.toMap(TextHoverRegistry.TextHoverExtension::getId, Function.identity()));
    }

    @Override
    public int compare(TextHoverRegistry.TextHoverExtension arg0, TextHoverRegistry.TextHoverExtension arg1) {
        if (this.isDeclaredAsBefore(arg0, arg1) || this.isDeclaredAsAfter(arg1, arg0)) {
            return -1;
        }
        if (this.isDeclaredAsAfter(arg0, arg1) || this.isDeclaredAsBefore(arg1, arg0)) {
            return 1;
        }
        return arg0.toString().compareTo(arg1.toString());
    }

    private boolean isDeclaredAsBefore(TextHoverRegistry.TextHoverExtension arg0, TextHoverRegistry.TextHoverExtension arg1) {
        String before0 = arg0.getIsBefore();
        if (before0 == null) {
            return false;
        }
        if ("*".equals(before0) && !"*".equals(arg1.getIsBefore())) {
            return true;
        }
        String id1 = arg1.getId();
        if (id1 == null) {
            return false;
        }
        if (before0.equals(id1)) {
            return true;
        }
        String after1 = arg1.getIsAfter();
        if (after1 == null) {
            return false;
        }
        return this.isDeclaredAsAfter(arg0, this.extensionsById.get(after1));
    }

    private boolean isDeclaredAsAfter(TextHoverRegistry.TextHoverExtension arg0, TextHoverRegistry.TextHoverExtension arg1) {
        String after0 = arg0.getIsAfter();
        if (after0 == null) {
            return false;
        }
        if ("*".equals(after0) && !"*".equals(arg1.getIsAfter())) {
            return true;
        }
        String id1 = arg1.getId();
        if (id1 == null) {
            return false;
        }
        if (after0.equals(id1)) {
            return true;
        }
        String before1 = arg1.getIsBefore();
        if (before1 == null) {
            return false;
        }
        return this.isDeclaredAsAfter(arg0, this.extensionsById.get(before1));
    }
}

