/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.bindings.internal.ContextSet;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.keys.IBindingService;

public class FullScreenHandler
extends AbstractHandler {
    private static final String FULL_SCREEN_COMMAND_ID = "org.eclipse.ui.window.fullscreenmode";
    private static final String FULL_SCREEN_COMMAND_DO_NOT_SHOW_INFO_AGAIN_PREF_ID = "org.eclipse.ui.window.fullscreenmode.donotshowinfoagain";
    private boolean showInfoPopup;
    private int timeLastEvent;
    private FullScreenInfoPopup fullScreenInfoPopup;

    public Object execute(ExecutionEvent event) {
        if (this.checkDuplicatedEvent(event)) {
            return null;
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow(event);
        Shell shell = window.getShell();
        IBindingService bindingService = (IBindingService)window.getService(IBindingService.class);
        ECommandService commandService = (ECommandService)window.getService(ECommandService.class);
        BindingTableManager bindingTableManager = (BindingTableManager)window.getService(BindingTableManager.class);
        IContextService bindingContextService = (IContextService)window.getService(IContextService.class);
        this.showInfoPopup = !WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(FULL_SCREEN_COMMAND_DO_NOT_SHOW_INFO_AGAIN_PREF_ID);
        Optional<TriggerSequence> sequence = this.getKeybindingSequence(bindingService, commandService, bindingTableManager, bindingContextService, FULL_SCREEN_COMMAND_ID);
        String keybinding = sequence.map(t -> t.format()).orElse("");
        shell.setFullScreen(!shell.getFullScreen());
        if (shell.getFullScreen()) {
            String message = WorkbenchMessages.ToggleFullScreenMode_ActivationPopup_Description_NoKeybinding;
            if (!keybinding.isEmpty()) {
                message = NLS.bind((String)WorkbenchMessages.ToggleFullScreenMode_ActivationPopup_Description, (Object)keybinding);
            }
            if (this.showInfoPopup) {
                this.fullScreenInfoPopup = new FullScreenInfoPopup(shell, 540676, true, false, false, false, false, null, null, message);
                this.fullScreenInfoPopup.open();
            }
        } else if (this.fullScreenInfoPopup != null) {
            this.fullScreenInfoPopup.close();
        }
        return Status.OK_STATUS;
    }

    boolean checkDuplicatedEvent(ExecutionEvent event) {
        if (event != null && event.getTrigger() != null && event.getTrigger() instanceof Event) {
            int time = ((Event)event.getTrigger()).time;
            if (time == this.timeLastEvent) {
                return true;
            }
            this.timeLastEvent = time;
        }
        return false;
    }

    protected Optional<TriggerSequence> getKeybindingSequence(IBindingService bindingService, ECommandService eCommandService, BindingTableManager bindingTableManager, IContextService contextService, String commandId) {
        TriggerSequence triggerSequence = bindingService.getBestActiveBindingFor(commandId);
        if (triggerSequence == null) {
            ParameterizedCommand cmd = eCommandService.createCommand(commandId, null);
            ContextSet contextSet = bindingTableManager.createContextSet(Arrays.asList(contextService.getDefinedContexts()));
            Binding binding = bindingTableManager.getBestSequenceFor(contextSet, cmd);
            if (binding != null) {
                triggerSequence = binding.getTriggerSequence();
            }
        }
        return Optional.ofNullable(triggerSequence);
    }

    private static class FullScreenInfoPopup
    extends PopupDialog {
        private String message;
        private String messageDoNotShowAgain;

        public FullScreenInfoPopup(Shell parent, int shellStyle, boolean takeFocusOnOpen, boolean persistSize, boolean persistLocation, boolean showDialogMenu, boolean showPersistActions, String titleText, String infoText, String message) {
            super(parent, shellStyle, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, infoText);
            this.message = message;
            this.messageDoNotShowAgain = WorkbenchMessages.ToggleFullScreenMode_ActivationPopup_DoNotShowAgain;
        }

        protected Point getInitialLocation(Point initialSize) {
            if (this.getShell().getParent() == null) {
                return super.getInitialLocation(initialSize);
            }
            Rectangle bounds = this.getShell().getParent().getMonitor().getBounds();
            GC gc = new GC((Drawable)this.getShell().getDisplay());
            int textExtendX = gc.textExtent((String)this.message).x;
            gc.dispose();
            return new Point(bounds.x + bounds.width / 2 - textExtendX / 2, bounds.y + bounds.height / 5);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label label = new Label(composite, 0);
            label.setText(this.message);
            GridData gd = new GridData(1809);
            gd.horizontalIndent = 1;
            gd.verticalIndent = 1;
            label.setLayoutData((Object)gd);
            Button btnDoNotShow = new Button(composite, 32);
            btnDoNotShow.setText(this.messageDoNotShowAgain);
            btnDoNotShow.setSelection(WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(FullScreenHandler.FULL_SCREEN_COMMAND_DO_NOT_SHOW_INFO_AGAIN_PREF_ID));
            GridData gd2 = new GridData(1809);
            gd2.horizontalIndent = 1;
            gd2.verticalIndent = 1;
            btnDoNotShow.setLayoutData((Object)gd2);
            composite.addDisposeListener(e -> WorkbenchPlugin.getDefault().getPreferenceStore().setValue(FullScreenHandler.FULL_SCREEN_COMMAND_DO_NOT_SHOW_INFO_AGAIN_PREF_ID, btnDoNotShow.getSelection()));
            return composite;
        }
    }
}

