/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.filters;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadStatusDataProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ActiveThreadsFilter
extends ViewerFilter {
    private final @NonNull List<Range<Long>> fCpuRanges;
    private @NonNull Map<ITmfTrace, Set<Long>> fCachedOnCpusThreadForTimeRange = new HashMap<ITmfTrace, Set<Long>>();
    private @NonNull Map<ITmfTrace, Set<Long>> fCachedActiveThreadForTimeRange = new HashMap<ITmfTrace, Set<Long>>();
    private TmfTimeRange fCachedTimeRange;
    private boolean fEnabled = false;
    private boolean fCpuRangesBasedFiltering = false;
    private final @Nullable ITmfTrace fTrace;

    public ActiveThreadsFilter(List<Range<Long>> cpuRanges, boolean cpuRangesBasedFiltering, @Nullable ITmfTrace trace) {
        this.fCpuRanges = cpuRanges != null ? ImmutableList.copyOf(cpuRanges) : Collections.emptyList();
        this.fCpuRangesBasedFiltering = cpuRangesBasedFiltering;
        this.fTrace = trace;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean isCpuRangesBased() {
        return this.fCpuRangesBasedFiltering;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    public @NonNull List<Range<Long>> getCpuRanges() {
        return this.fCpuRanges;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!this.fEnabled || !(element instanceof ControlFlowEntry)) {
            return true;
        }
        ControlFlowEntry cfe = (ControlFlowEntry)((Object)element);
        ITmfTrace trace = BaseDataProviderTimeGraphView.getTrace((TimeGraphEntry)cfe);
        Set<Long> onCpusThreadForTimeRange = this.fCachedOnCpusThreadForTimeRange.get(trace);
        Set<Long> activeThreadForTimeRange = this.fCachedActiveThreadForTimeRange.get(trace);
        if (this.fCpuRangesBasedFiltering && onCpusThreadForTimeRange != null && onCpusThreadForTimeRange.contains(cfe.getEntryModel().getId())) {
            return true;
        }
        if (activeThreadForTimeRange != null && activeThreadForTimeRange.contains(cfe.getEntryModel().getId())) {
            return true;
        }
        for (TimeGraphEntry child : cfe.getChildren()) {
            if (!this.select(viewer, (Object)cfe, child)) continue;
            return true;
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull Set<Long> getOnCpuThreads(@NonNull List<Range<Long>> cpuRanges, TmfTimeRange winRange, @NonNull ITmfTrace trace) {
        ThreadStatusDataProvider threadStatusProvider = (ThreadStatusDataProvider)DataProviderManager.getInstance().getDataProvider(trace, "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadStatusDataProvider", ThreadStatusDataProvider.class);
        if (threadStatusProvider == null) {
            return Collections.emptySet();
        }
        long beginTS = winRange.getStartTime().getValue();
        long endTS = winRange.getEndTime().getValue();
        @NonNull HashSet<@NonNull Long> cpus = new HashSet<Long>();
        for (Range<Long> range : cpuRanges) {
            long cpu = (Long)range.lowerEndpoint();
            while (cpu <= (Long)range.upperEndpoint()) {
                cpus.add(cpu);
                ++cpu;
            }
        }
        SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(beginTS, endTS, 2, cpus);
        @NonNull @NonNull Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
        parameters.put("active_thread_filter", true);
        @NonNull TmfModelResponse response = threadStatusProvider.fetchTree(parameters, null);
        @NonNull TmfTreeModel model = (TmfTreeModel)response.getModel();
        if (model == null) {
            return Collections.emptySet();
        }
        HashSet onCpuThreads = Sets.newHashSet((Iterable)Iterables.transform((Iterable)model.getEntries(), TmfTreeDataModel::getId));
        return onCpuThreads == null ? Collections.emptySet() : onCpuThreads;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull Set<Long> getActiveThreads(TmfTimeRange winRange, @NonNull ITmfTrace trace) {
        ThreadStatusDataProvider threadStatusProvider = (ThreadStatusDataProvider)DataProviderManager.getInstance().getDataProvider(trace, "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadStatusDataProvider", ThreadStatusDataProvider.class);
        if (threadStatusProvider == null) {
            return Collections.emptySet();
        }
        long beginTS = winRange.getStartTime().getValue();
        long endTS = winRange.getEndTime().getValue();
        TimeQueryFilter filter = new TimeQueryFilter(beginTS, endTS, 2);
        @NonNull @NonNull Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter);
        parameters.put("active_thread_filter", true);
        @NonNull TmfModelResponse response = threadStatusProvider.fetchTree(parameters, null);
        @NonNull TmfTreeModel model = (TmfTreeModel)response.getModel();
        if (model == null) {
            return Collections.emptySet();
        }
        HashSet activeThreads = Sets.newHashSet((Iterable)Iterables.transform((Iterable)model.getEntries(), TmfTreeDataModel::getId));
        return activeThreads == null ? Collections.emptySet() : activeThreads;
    }

    public @Nullable Map<ITmfTrace, Set<Long>> computeData(long beginTS, long endTS) {
        TmfTimeRange timeRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)beginTS), TmfTimestamp.fromNanos((long)endTS));
        ITmfTrace parentTrace = this.fTrace;
        if (parentTrace == null || !this.fEnabled || this.fCachedTimeRange != null && this.fCachedTimeRange.equals((Object)timeRange)) {
            return null;
        }
        HashMap<ITmfTrace, Set<Long>> data = new HashMap<ITmfTrace, Set<Long>>();
        for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)parentTrace)) {
            if (this.fCpuRangesBasedFiltering) {
                Set<Long> onCpusThreadForTimeRange = ActiveThreadsFilter.getOnCpuThreads(this.fCpuRanges, timeRange, trace);
                data.put(trace, onCpusThreadForTimeRange);
                continue;
            }
            Set<Long> activeThreadForTimeRange = ActiveThreadsFilter.getActiveThreads(timeRange, trace);
            data.put(trace, activeThreadForTimeRange);
        }
        return data;
    }

    public void updateData(long beginTS, long endTS, @NonNull Map<ITmfTrace, Set<Long>> data) {
        this.fCachedTimeRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)beginTS), TmfTimestamp.fromNanos((long)endTS));
        if (this.fCpuRangesBasedFiltering) {
            this.fCachedOnCpusThreadForTimeRange = data;
        } else {
            this.fCachedActiveThreadForTimeRange = data;
        }
    }

    public int hashCode() {
        return Objects.hash(this.fCpuRanges, this.fCpuRangesBasedFiltering, this.fEnabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ActiveThreadsFilter other = (ActiveThreadsFilter)((Object)obj);
        return Objects.equals(this.fCpuRanges, other.fCpuRanges) && this.fCpuRangesBasedFiltering == other.fCpuRangesBasedFiltering && this.fEnabled == other.fEnabled;
    }
}

