/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class MarkerUtilities {
    private static MarkerTypeHierarchy fgMarkerTypeHierarchy;

    private MarkerUtilities() {
    }

    public static int getCharEnd(IMarker marker) {
        return MarkerUtilities.getIntAttribute(marker, "charEnd", -1);
    }

    public static int getCharStart(IMarker marker) {
        return MarkerUtilities.getIntAttribute(marker, "charStart", -1);
    }

    private static int getIntAttribute(IMarker marker, String attributeName, int defaultValue) {
        if (marker.exists()) {
            return marker.getAttribute(attributeName, defaultValue);
        }
        return defaultValue;
    }

    public static int getLineNumber(IMarker marker) {
        return MarkerUtilities.getIntAttribute(marker, "lineNumber", -1);
    }

    public static int getPriority(IMarker marker) {
        return MarkerUtilities.getIntAttribute(marker, "priority", 1);
    }

    public static int getSeverity(IMarker marker) {
        return MarkerUtilities.getIntAttribute(marker, "severity", 0);
    }

    private static void handleCoreException(CoreException e) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = ILog.of((Bundle)bundle);
        log.log(e.getStatus());
    }

    public static boolean isMarkerType(IMarker marker, String type) {
        if (marker != null) {
            try {
                return marker.exists() && marker.isSubtypeOf(type);
            }
            catch (CoreException x) {
                MarkerUtilities.handleCoreException(x);
            }
        }
        return false;
    }

    public static String getMarkerType(IMarker marker) {
        try {
            return marker.getType();
        }
        catch (CoreException x) {
            MarkerUtilities.handleCoreException(x);
            return null;
        }
    }

    public static String getMessage(IMarker marker) {
        return marker.getAttribute("message", null);
    }

    public static void setCharEnd(IMarker marker, int charEnd) {
        MarkerUtilities.setIntAttribute(marker, "charEnd", charEnd);
    }

    public static void setCharEnd(Map<String, Object> map, int charEnd) {
        map.put("charEnd", charEnd);
    }

    public static void setCharStart(IMarker marker, int charStart) {
        MarkerUtilities.setIntAttribute(marker, "charStart", charStart);
    }

    public static void setCharStart(Map<String, Object> map, int charStart) {
        map.put("charStart", charStart);
    }

    private static void setIntAttribute(IMarker marker, String attributeName, int value) {
        try {
            if (marker.exists()) {
                marker.setAttribute(attributeName, value);
            }
        }
        catch (CoreException e) {
            MarkerUtilities.handleCoreException(e);
        }
    }

    public static void setLineNumber(IMarker marker, int lineNum) {
        MarkerUtilities.setIntAttribute(marker, "lineNumber", lineNum);
    }

    public static void setLineNumber(Map<String, Object> map, int lineNum) {
        map.put("lineNumber", lineNum);
    }

    public static void setMessage(Map<String, Object> map, String message) {
        map.put("message", message);
    }

    public static void createMarker(IResource resource, Map<String, Object> attributes, String markerType) throws CoreException {
        IWorkspaceRunnable r = monitor -> {
            IMarker marker = resource.createMarker(markerType);
            marker.setAttributes(attributes);
        };
        resource.getWorkspace().run(r, null, 1, null);
    }

    public static String[] getSuperTypes(String markerType) {
        if (fgMarkerTypeHierarchy == null) {
            fgMarkerTypeHierarchy = new MarkerTypeHierarchy();
        }
        return fgMarkerTypeHierarchy.getSuperTypes(markerType);
    }

    public static void changeAttributes(IMarker marker, Map<String, Object> attributeChanges) {
        Set<Map.Entry<String, Object>> entries = attributeChanges.entrySet();
        int size = entries.size();
        String[] keys = new String[size];
        Object[] values = new Object[size];
        int i = 0;
        for (Map.Entry<String, Object> e : entries) {
            keys[i] = e.getKey();
            values[i] = e.getValue();
            ++i;
        }
        try {
            if (marker.exists()) {
                marker.setAttributes(keys, values);
            }
        }
        catch (CoreException e) {
            MarkerUtilities.handleCoreException(e);
        }
    }

    private static class MarkerTypeHierarchy {
        private Map<String, String[]> fTypeMap;
        private Map<String, String[]> fSuperTypesCache = new HashMap<String, String[]>();

        private MarkerTypeHierarchy() {
        }

        public String[] getSuperTypes(String typeName) {
            String[] cachedTypes = this.fSuperTypesCache.get(typeName);
            if (cachedTypes == null) {
                cachedTypes = this.computeSuperTypes(typeName);
                this.fSuperTypesCache.put(typeName, cachedTypes);
            }
            return cachedTypes;
        }

        private String[] computeSuperTypes(String typeName) {
            ArrayList types = new ArrayList();
            this.appendAll(types, this.getDirectSuperTypes(typeName));
            int index = 0;
            while (index < types.size()) {
                String type = (String)types.get(index++);
                this.appendAll(types, this.getDirectSuperTypes(type));
            }
            String[] superTypes = new String[types.size()];
            types.toArray(superTypes);
            return superTypes;
        }

        private String[] getDirectSuperTypes(String typeName) {
            return this.getTypeMap().get(typeName);
        }

        private <T> void appendAll(List<T> list, T[] objects) {
            if (objects == null) {
                return;
            }
            T[] TArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                T o = TArray[n2];
                if (!list.contains(o)) {
                    list.add(o);
                }
                ++n2;
            }
        }

        private Map<String, String[]> getTypeMap() {
            if (this.fTypeMap == null) {
                this.fTypeMap = this.readTypes();
            }
            return this.fTypeMap;
        }

        private Map<String, String[]> readTypes() {
            HashMap<String, String[]> allTypes = new HashMap<String, String[]>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "markers");
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    ArrayList<String> types = new ArrayList<String>();
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String type;
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (element.getName().equalsIgnoreCase("super") && (type = element.getAttribute("type")) != null) {
                            types.add(type);
                        }
                        ++n4;
                    }
                    String[] superTypes = new String[types.size()];
                    types.toArray(superTypes);
                    allTypes.put(extension.getUniqueIdentifier(), superTypes);
                    ++n2;
                }
            }
            return allTypes;
        }
    }
}

