/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.keywords;

import org.eclipse.core.runtime.Path;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ease.modules.platform.keywords.ScriptedView;
import org.eclipse.ease.modules.platform.uibuilder.UIBuilderModule;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RegisterView
implements EventHandler {
    public static MApplication getApplication() {
        return ((IWorkbench)PlatformUI.getWorkbench().getService(IWorkbench.class)).getApplication();
    }

    private static MPartDescriptor createPartDescriptor() {
        EModelService modelService = (EModelService)PlatformUI.getWorkbench().getService(EModelService.class);
        return (MPartDescriptor)modelService.createModelElement(MPartDescriptor.class);
    }

    private static String getCategory(String viewName) {
        Path viewPath = new Path(viewName);
        return viewPath.segmentCount() >= 2 ? viewPath.segment(0) : "Scripted Views";
    }

    private static String getLabel(String viewName) {
        Path viewPath = new Path(viewName);
        return viewPath.lastSegment();
    }

    public void handleEvent(Event event) {
        IScript script = (IScript)event.getProperty("script");
        String value = (String)event.getProperty("value");
        String oldValue = (String)event.getProperty("oldValue");
        if (oldValue != null && !oldValue.isEmpty()) {
            this.removeContribution(script, oldValue);
        }
        if (value != null && !value.isEmpty()) {
            this.addContribution(script, value);
        }
    }

    private void addContribution(IScript script, String viewName) {
        String iconUri = (String)script.getKeywords().get("image");
        iconUri = iconUri == null ? "platform:/plugin/org.eclipse.ease.modules.platform/icons/eview16/scripted_view.png" : iconUri;
        MPartDescriptor partDescriptor = RegisterView.createPartDescriptor();
        partDescriptor.setCategory(RegisterView.getCategory(viewName));
        partDescriptor.setAllowMultiple(false);
        partDescriptor.setCloseable(true);
        partDescriptor.setLabel(RegisterView.getLabel(viewName));
        partDescriptor.setIconURI(iconUri);
        partDescriptor.setContributionURI("bundleclass://org.eclipse.ease.modules.platform/" + ScriptedView.class.getName());
        partDescriptor.setElementId(UIBuilderModule.getDynamicViewId());
        partDescriptor.getProperties().put("script", script.getPath().toString());
        partDescriptor.getTags().add("View");
        partDescriptor.getPersistedState().put("persistState", Boolean.FALSE.toString());
        RegisterView.getApplication().getDescriptors().add(partDescriptor);
    }

    private void removeContribution(IScript script, String viewName) {
        String category = RegisterView.getCategory(viewName);
        String label = RegisterView.getLabel(viewName);
        for (MPartDescriptor descriptor : RegisterView.getApplication().getDescriptors()) {
            if (!label.equals(descriptor.getLabel()) || !category.equals(descriptor.getCategory())) continue;
            RegisterView.getApplication().getDescriptors().remove(descriptor);
            break;
        }
    }
}

