/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.scripts.ScriptStorage;

public class FileScriptStorage
extends ScriptStorage {
    public FileScriptStorage(String location) {
        super(location);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean createFile(Path path, String content) {
        URI uri = URI.create(new Path(this.getLocation()).append((IPath)path).toString().replace(" ", "%20"));
        File file = new File(uri);
        try {
            if (file.exists()) return false;
            if (!file.createNewFile()) return false;
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(file);
                outputStream.write(content.getBytes());
                return true;
            }
            catch (Exception e) {
                Logger.error((String)"org.eclipse.ease.ui.scripts", (String)"Could not store recorded script.", (Throwable)e);
                return false;
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException e2) {
            Logger.error((String)"org.eclipse.ease.ui.scripts", (String)"Could not create file", (Throwable)e2);
        }
        return false;
    }

    @Override
    protected boolean createPath(IPath path) {
        File file = new File(URI.create((String.valueOf(this.getLocation()) + "/" + path).replace(" ", "%20")));
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }
}

