/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.event;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.IGenericFtraceConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;

@NonNullByDefault
public class GenericFtraceField {
    private static final Pattern KEYVAL_PATTERN = Pattern.compile("(?<key>[^\\s=\\[\\],]+)(=|:)\\s*(?<val>[^\\s=\\[\\],]+)");
    private static final String KEYVAL_KEY_GROUP = "key";
    private static final String KEYVAL_VAL_GROUP = "val";
    private static final double SECONDS_TO_NANO = 1.0E9;
    private static final Map<Character, @NonNull Long> PREV_STATE_LUT;
    private final Long fTs;
    private String fName;
    private final Integer fCpu;
    private @Nullable Integer fTid;
    private @Nullable Integer fPid;
    private ITmfEventField fContent;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static {
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)Character.valueOf('R'), (Object)0L);
        builder.put((Object)Character.valueOf('S'), (Object)1L);
        builder.put((Object)Character.valueOf('D'), (Object)2L);
        builder.put((Object)Character.valueOf('T'), (Object)4L);
        builder.put((Object)Character.valueOf('t'), (Object)8L);
        builder.put((Object)Character.valueOf('X'), (Object)16L);
        builder.put((Object)Character.valueOf('x'), (Object)16L);
        builder.put((Object)Character.valueOf('Z'), (Object)32L);
        builder.put((Object)Character.valueOf('P'), (Object)64L);
        builder.put((Object)Character.valueOf('I'), (Object)128L);
        PREV_STATE_LUT = builder.build();
    }

    public GenericFtraceField(String name, Integer cpu, Long ts, @Nullable Integer pid, @Nullable Integer tid, Map<String, Object> fields) {
        this.fName = name;
        this.fCpu = cpu;
        this.fPid = pid;
        this.fTid = tid;
        ITmfEventField[] array = (ITmfEventField[])fields.entrySet().stream().map(entry -> new TmfEventField((String)entry.getKey(), entry.getValue(), null)).toArray(ITmfEventField[]::new);
        this.fContent = new TmfEventField(":root:", fields, array);
        this.fTs = ts;
    }

    public static @Nullable GenericFtraceField parseLine(String line) {
        Matcher matcher = IGenericFtraceConstants.FTRACE_PATTERN.matcher(line);
        if (matcher.matches()) {
            String key;
            Integer tgidNumeric;
            Integer pid;
            Integer tid = pid = Integer.valueOf(Integer.parseInt(matcher.group("pid")));
            Integer cpu = Integer.parseInt(matcher.group("cpu"));
            Double timestampInSec = Double.parseDouble(matcher.group("timestamp"));
            Long timestampInNano = (long)(timestampInSec * 1.0E9);
            String name = matcher.group("name");
            name = name.trim();
            String separator = matcher.group("separator");
            separator = separator.trim();
            String attributes = matcher.group("data");
            name = GenericFtraceField.eventNameRewrite(name, separator);
            String tgid = matcher.group("tgid");
            if (tgid != null && !(tgidNumeric = Integer.valueOf(Integer.parseInt(tgid))).equals(pid)) {
                pid = tgidNumeric;
            }
            HashMap<@NonNull String, @NonNull Object> fields = new HashMap<String, Object>();
            Matcher keyvalMatcher = KEYVAL_PATTERN.matcher(attributes);
            while (keyvalMatcher.find()) {
                key = keyvalMatcher.group(KEYVAL_KEY_GROUP);
                String value = keyvalMatcher.group(KEYVAL_VAL_GROUP);
                if (value == null) continue;
                if (key.equals("prev_state")) {
                    fields.put(key, GenericFtraceField.parsePrevStateValue(value));
                    continue;
                }
                if (StringUtils.isNumeric((CharSequence)value)) {
                    if (key.equals("parent_pid") && name.equals("sched_process_fork")) {
                        key = "pid";
                    }
                    fields.put(key, Long.parseUnsignedLong(value));
                    continue;
                }
                fields.put(key, GenericFtraceField.decodeString(value));
            }
            if (fields.isEmpty() && attributes != null && !attributes.isEmpty()) {
                key = "data";
                if (name.equals("exit_syscall")) {
                    key = "ret";
                }
                fields.put(key, GenericFtraceField.decodeString(attributes));
            }
            return new GenericFtraceField(name, cpu, timestampInNano, pid, tid, fields);
        }
        return null;
    }

    private static Object decodeString(String val) {
        try {
            if (val.startsWith("0x") || val.startsWith("0X")) {
                return Long.parseUnsignedLong(val.substring(2), 16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    public ITmfEventField getContent() {
        return this.fContent;
    }

    public void setContent(Map<String, Object> fields) {
        ITmfEventField[] array = (ITmfEventField[])fields.entrySet().stream().map(entry -> new TmfEventField((String)entry.getKey(), entry.getValue(), null)).toArray(ITmfEventField[]::new);
        this.fContent = new TmfEventField(":root:", fields, array);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public @Nullable Integer getTid() {
        return this.fTid;
    }

    public void setTid(Integer tid) {
        this.fTid = tid;
    }

    public Long getTs() {
        return this.fTs;
    }

    public @Nullable Integer getPid() {
        return this.fPid;
    }

    public void setPid(Integer pid) {
        this.fPid = pid;
    }

    public Integer getCpu() {
        return this.fCpu;
    }

    private static Long parsePrevStateValue(String value) {
        Long state = 0L;
        state = StringUtils.isNumeric((CharSequence)value) ? Long.valueOf(Long.parseUnsignedLong(value)) : PREV_STATE_LUT.getOrDefault(Character.valueOf(value.charAt(0)), 0L);
        return state;
    }

    private static String eventNameRewrite(@Nullable String name, @Nullable String separator) {
        String newname;
        if (name == null) {
            return "";
        }
        if (name.startsWith("sys_") && separator != null && separator.equals("->") || name.startsWith("sys_exit_")) {
            return "exit_syscall";
        }
        if (name.startsWith("sys_enter_") && (newname = name.replaceFirst("sys_enter_", "sys_")) != null) {
            return newname;
        }
        return name;
    }
}

