/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.trace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.trace.GenericFtrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;

public class BinaryFTrace
extends GenericFtrace
implements ITmfPropertiesProvider {
    private static final String TRACE_CMD = "trace-cmd";
    private static final String REPORT = "report";
    private final @NonNull Map<@NonNull String, @NonNull String> fProperties = new LinkedHashMap<String, String>();

    /*
     * Unable to fully structure code
     */
    public IStatus validate(IProject project, String path) {
        block25: {
            file = new File(path);
            if (!file.exists()) {
                return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "File not found: " + path);
            }
            if (!file.isFile()) {
                return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "Not a file. It's a directory: " + path);
            }
            confidence = 32;
            try {
                block26: {
                    if (TmfTraceUtils.isText((File)file)) break block25;
                    magicLength = BinaryFTrace.TRACE_CMD_DAT_MAGIC.length;
                    if (file.length() <= (long)magicLength) break block25;
                    var6_7 = null;
                    var7_9 = null;
                    try {
                        block28: {
                            fis = new FileInputStream(file);
                            start = new byte[magicLength];
                            read = fis.read(start);
                            if (read != magicLength || !Arrays.equals(BinaryFTrace.TRACE_CMD_DAT_MAGIC, start)) break block26;
                            pb = new ProcessBuilder(new String[]{"trace-cmd"});
                            traceCmd = pb.start();
                            var13_16 = null;
                            var14_18 = null;
                            br = new BufferedReader(new InputStreamReader(traceCmd.getInputStream(), Charset.forName("UTF-8")));
                            line = br.readLine();
lbl28:
                            // 1 sources

                            if (!line.contains("report")) ** break block27
                            v0 = new TraceValidationStatus(confidence, "org.eclipse.tracecompass.incubator.ftrace.core");
                            if (br == null) break block28;
                            br.close();
                        }
                        return v0;
                        {
                            try {
                                line = br.readLine();
                                return line;
                                if (br != null) {
                                    br.close();
                                }
                                break block26;
                                {
                                    catch (Throwable var13_17) {
                                        if (br != null) {
                                            br.close();
                                        }
                                        throw var13_17;
                                    }
                                }
                            }
                            catch (Throwable var14_19) {
                                if (var13_16 == null) {
                                    var13_16 = var14_19;
                                } else if (var13_16 != var14_19) {
                                    var13_16.addSuppressed(var14_19);
                                }
                                throw var13_16;
                            }
                        }
                        finally {
                            if (line != null) ** GOTO lbl28
                        }
                    }
                    catch (Throwable var7_10) {
                        if (var6_7 == null) {
                            var6_7 = var7_10;
                        } else if (var6_7 != var7_10) {
                            var6_7.addSuppressed(var7_10);
                        }
                        throw var6_7;
                    }
                }
                return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "Magic mismatch");
            }
            catch (IOException e) {
                Activator.getInstance().logError("Error validating file: " + path, (Throwable)e);
                if (e.getMessage().startsWith("Cannot run program: \"trace-cmd\": error=2,")) {
                    return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "It appears trace-cmd is not available on your machine. Please install it to use the binary ftrace parser. (sudo apt install trace-cmd)", (Throwable)e);
                }
                return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "IOException validating file: " + path, (Throwable)e);
            }
        }
        return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "Not an FTrace bin");
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type, String name, String traceTypeId) throws TmfTraceException {
        super.initTrace(resource, path, type, name, traceTypeId);
        this.fProperties.put("Type", "Trace-Event");
        String dir = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)this);
        if (!new File(dir).exists()) {
            throw new TmfTraceException("Could not create temporary folder " + dir);
        }
        File file = new File(String.valueOf(dir) + new File(path).getName());
        if (!file.exists()) {
            ProcessBuilder pb = new ProcessBuilder(TRACE_CMD, REPORT, "-i", path, "-R");
            pb.redirectOutput(file);
            try {
                pb.start().waitFor();
            }
            catch (IOException | InterruptedException e) {
                throw new TmfTraceException(e.getMessage(), (Throwable)e);
            }
            if (!file.exists()) {
                throw new TmfTraceException("Could not create temporary file " + file.getAbsolutePath());
            }
            if (file.length() <= 0L) {
                throw new TmfTraceException("Empty temporary file " + file.getAbsolutePath());
            }
        }
        this.setFile(file);
    }

    public @NonNull Map<@NonNull String, @NonNull String> getProperties() {
        return this.fProperties;
    }
}

