/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IDataPalette;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeSet;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTreeSet;
import org.eclipse.tracecompass.incubator.internal.analysis.core.weighted.tree.DifferentialPalette;

public class DifferentialWeightedTreeProvider<@NonNull N>
implements IWeightedTreeProvider<N, Object, DifferentialWeightedTree<N>> {
    private static final Format FORMAT = new DecimalFormat("#.#");
    private static final Format DIFFERENTIAL_FORMAT = new Format(){
        private static final long serialVersionUID = 9150811551603074986L;

        @Override
        public @Nullable StringBuffer format(@Nullable Object obj, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
            StringBuffer buf = toAppendTo;
            if (buf == null) {
                buf = new StringBuffer();
            }
            if (obj instanceof Number) {
                double num = ((Number)obj).doubleValue();
                if (num == 0.0) {
                    return buf.append("No Difference");
                }
                return buf.append(num > 0.0 ? "+" : "").append(FORMAT.format(num * 100.0)).append("%");
            }
            return FORMAT.format(obj, toAppendTo, pos);
        }

        @Override
        public @Nullable Object parseObject(@Nullable String source, @Nullable ParsePosition pos) {
            return null;
        }
    };
    private static final List<IWeightedTreeProvider.MetricType> WEIGHT_TYPES = Collections.singletonList(new IWeightedTreeProvider.MetricType("Differential", IWeightedTreeProvider.DataType.OTHER, DIFFERENTIAL_FORMAT));
    private final IWeightedTreeSet<N, Object, DifferentialWeightedTree<N>> fTreeSet;
    private final IWeightedTreeProvider<N, ?, WeightedTree<N>> fOriginalTree;
    private final List<IWeightedTreeProvider.MetricType> fAdditionalMetrics = new ArrayList<IWeightedTreeProvider.MetricType>(WEIGHT_TYPES);
    private @Nullable IDataPalette fPalette = null;

    public DifferentialWeightedTreeProvider(IWeightedTreeProvider<N, ?, WeightedTree<N>> originalTree, Collection<DifferentialWeightedTree<N>> trees) {
        this(originalTree, DifferentialWeightedTreeSet.create(trees));
    }

    public DifferentialWeightedTreeProvider(IWeightedTreeProvider<N, ?, WeightedTree<N>> originalTree, DifferentialWeightedTreeSet<N> treeSet) {
        this.fOriginalTree = originalTree;
        this.fTreeSet = treeSet;
        this.fAdditionalMetrics.addAll(this.fOriginalTree.getAdditionalMetrics());
    }

    public void setHeatThresholds(int minThreshold, int maxThreshold) {
        if (minThreshold == maxThreshold) {
            this.fPalette = DifferentialPalette.getInstance();
        }
        this.fPalette = DifferentialPalette.create(minThreshold, maxThreshold);
    }

    @Override
    public String getTitle() {
        return "Differential tree";
    }

    @Override
    public @NonNull IWeightedTreeProvider.MetricType getWeightType() {
        return this.fOriginalTree.getWeightType();
    }

    @Override
    public String toDisplayString(DifferentialWeightedTree<N> tree) {
        return this.fOriginalTree.toDisplayString(tree.getOriginalTree());
    }

    @Override
    public List<IWeightedTreeProvider.MetricType> getAdditionalMetrics() {
        return this.fAdditionalMetrics;
    }

    @Override
    public Object getAdditionalMetric(DifferentialWeightedTree<N> object, int metricIndex) {
        if (metricIndex == 0) {
            return object.getDifference();
        }
        return this.fOriginalTree.getAdditionalMetric(object.getOriginalTree(), metricIndex - 1);
    }

    @Override
    public IWeightedTreeSet<N, Object, DifferentialWeightedTree<N>> getTreeSet() {
        return this.fTreeSet;
    }

    @Override
    public IDataPalette getPalette() {
        IDataPalette palette = this.fPalette;
        return palette == null ? DifferentialPalette.getInstance() : palette;
    }
}

