/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiComparators;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiGenericAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.Messages;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;

public class LamiTimeRangeDurationAspect
extends LamiGenericAspect {
    private final int fColIndex;

    public LamiTimeRangeDurationAspect(String timeRangeName, int colIndex) {
        super(String.valueOf(timeRangeName) + " (" + Messages.LamiAspect_TimeRangeDuration + ')', "ns", colIndex, true, false);
        this.fColIndex = colIndex;
    }

    @Override
    public boolean isTimeDuration() {
        return true;
    }

    @Override
    public @Nullable String resolveString(LamiTableEntry entry) {
        LamiTimeRange range;
        Long duration;
        LamiData data = entry.getValue(this.fColIndex);
        if (data instanceof LamiTimeRange && (duration = (range = (LamiTimeRange)data).getDuration()) != null) {
            return String.valueOf(duration);
        }
        return data.toString();
    }

    @Override
    public @Nullable Number resolveNumber(@NonNull LamiTableEntry entry) {
        LamiData data = entry.getValue(this.fColIndex);
        if (data instanceof LamiTimeRange) {
            LamiTimeRange range = (LamiTimeRange)data;
            return range.getDuration();
        }
        return null;
    }

    @Override
    public Comparator<LamiTableEntry> getComparator() {
        return LamiComparators.getLongComparator(this::resolveNumber);
    }
}

