/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.Messages;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreScatterDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.internal.tmf.core.model.xy.TmfTreeXYCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class SegmentStoreScatterDataProviderFactory
implements IDataProviderFactory {
    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        return null;
    }

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace, String secondaryId) {
        ITmfTreeDataProvider<? extends ITmfTreeDataModel> provider = SegmentStoreScatterDataProvider.create(trace, secondaryId);
        if (provider != null) {
            return provider;
        }
        Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        if (traces.size() == 1) {
            return SegmentStoreScatterDataProvider.create(trace, secondaryId);
        }
        return TmfTreeXYCompositeDataProvider.create((Collection)traces, (String)Objects.requireNonNull(Messages.SegmentStoreScatterGraphViewer_title), (String)"org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.scatter.dataprovider", (String)secondaryId);
    }

    public Collection<IDataProviderDescriptor> getDescriptors(ITmfTrace trace) {
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ISegmentStoreProvider.class);
        ArrayList<IDataProviderDescriptor> descriptors = new ArrayList<IDataProviderDescriptor>();
        HashSet<String> existingModules = new HashSet<String>();
        for (ISegmentStoreProvider module : modules) {
            IAnalysisModule analysis = (IAnalysisModule)module;
            if (existingModules.contains(analysis.getId())) continue;
            DataProviderDescriptor.Builder builder = new DataProviderDescriptor.Builder();
            builder.setId("org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.scatter.dataprovider:" + analysis.getId()).setName(Objects.requireNonNull(NLS.bind((String)Messages.SegmentStoreScatterGraphDataProvider_title, (Object)analysis.getName()))).setDescription(Objects.requireNonNull(NLS.bind((String)Messages.SegmentStoreScatterGraphDataProvider_description, (Object)analysis.getHelpText()))).setProviderType(IDataProviderDescriptor.ProviderType.TREE_TIME_XY);
            descriptors.add(builder.build());
            existingModules.add(analysis.getId());
        }
        return descriptors;
    }
}

