/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.resources.ResourcesUtil;
import org.eclipse.cdt.internal.core.Messages;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlUtil {
    private static final String ENCODING_UTF_8 = "UTF-8";
    private static final String EOL_XML = "\n";
    private static final String DEFAULT_IDENT = "\t";
    private static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.newDocument();
    }

    public static String determineNodeValue(Node node) {
        return node != null ? node.getNodeValue() : null;
    }

    public static String determineAttributeValue(Node element, String attr) {
        NamedNodeMap attributes = element.getAttributes();
        return attributes != null ? XmlUtil.determineNodeValue(attributes.getNamedItem(attr)) : null;
    }

    public static Element appendElement(Node parent, String name, String[] attributes) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement(name);
        if (attributes != null) {
            int attrLen = attributes.length;
            int i = 0;
            while (i < attrLen) {
                String attrName = attributes[i];
                String attrValue = attributes[i + 1];
                element.setAttribute(attrName, attrValue);
                i += 2;
            }
        }
        parent.appendChild(element);
        return element;
    }

    public static Element appendElement(Node parent, String name) {
        return XmlUtil.appendElement(parent, name, null);
    }

    public static void prettyFormat(Document doc) {
        XmlUtil.prettyFormat(doc, DEFAULT_IDENT);
    }

    public static void prettyFormat(Document doc, String ident) {
        doc.normalize();
        Element documentElement = doc.getDocumentElement();
        if (documentElement != null) {
            XmlUtil.prettyFormat(documentElement, "", ident);
        }
    }

    private static void prettyFormat(Node node, String identLevel, String ident) {
        short type;
        NodeList nodelist = node.getChildNodes();
        int iStart = 0;
        Node item = nodelist.item(0);
        if (item != null && ((type = item.getNodeType()) == 1 || type == 8)) {
            Text newChild = node.getOwnerDocument().createTextNode(EOL_XML + identLevel + ident);
            node.insertBefore(newChild, item);
            iStart = 1;
        }
        int i = iStart;
        while (i < nodelist.getLength()) {
            item = nodelist.item(i);
            if (item != null) {
                short type2 = item.getNodeType();
                if (type2 == 3 && item.getNodeValue().trim().length() == 0) {
                    if (i + 1 < nodelist.getLength()) {
                        item.setNodeValue(EOL_XML + identLevel + ident);
                    } else {
                        item.setNodeValue(EOL_XML + identLevel);
                    }
                } else if (type2 == 1) {
                    XmlUtil.prettyFormat(item, String.valueOf(identLevel) + ident, ident);
                    if (i + 1 < nodelist.getLength()) {
                        short nextType;
                        Node nextItem = nodelist.item(i + 1);
                        if (nextItem != null && ((nextType = nextItem.getNodeType()) == 1 || nextType == 8)) {
                            Text newChild = node.getOwnerDocument().createTextNode(EOL_XML + identLevel + ident);
                            node.insertBefore(newChild, nextItem);
                            ++i;
                        }
                    } else {
                        Text newChild = node.getOwnerDocument().createTextNode(EOL_XML + identLevel);
                        node.appendChild(newChild);
                        ++i;
                    }
                }
            }
            ++i;
        }
    }

    private static Document loadXml(InputStream xmlStream) throws CoreException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(xmlStream);
        }
        catch (Exception e) {
            throw new CoreException(CCorePlugin.createStatus(Messages.XmlUtil_InternalErrorLoading, e));
        }
    }

    public static Document loadXml(URI uriLocation) throws CoreException {
        Document document;
        File xmlFile = new File(uriLocation);
        if (!xmlFile.exists()) {
            return null;
        }
        FileInputStream xmlStream = new FileInputStream(xmlFile);
        try {
            document = XmlUtil.loadXml(xmlStream);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)xmlStream).close();
                throw throwable;
            }
            catch (Exception e) {
                throw new CoreException(CCorePlugin.createStatus(Messages.XmlUtil_InternalErrorLoading, e));
            }
        }
        ((InputStream)xmlStream).close();
        return document;
    }

    public static Document loadXml(IFile xmlFile) throws CoreException {
        Document document;
        InputStream xmlStream = xmlFile.getContents();
        try {
            document = XmlUtil.loadXml(xmlStream);
        }
        catch (Throwable throwable) {
            try {
                xmlStream.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new CoreException(CCorePlugin.createStatus(Messages.XmlUtil_InternalErrorLoading, e));
            }
        }
        xmlStream.close();
        return document;
    }

    public static void serializeXml(Document doc, URI uriLocation, String lineSeparator) throws IOException, TransformerException, CoreException {
        XmlUtil.prettyFormat(doc);
        File storeFile = new File(uriLocation);
        if (!storeFile.exists()) {
            storeFile.createNewFile();
        }
        String utfString = new String(XmlUtil.toByteArray(doc), ENCODING_UTF_8);
        utfString = XmlUtil.replaceLineSeparatorInternal(utfString, lineSeparator);
        FileOutputStream output = XmlUtil.getFileOutputStreamWorkaround(storeFile);
        output.write(utfString.getBytes(ENCODING_UTF_8));
        output.close();
        ResourcesUtil.refreshWorkspaceFiles(uriLocation);
    }

    private static FileOutputStream getFileOutputStreamWorkaround(File storeFile) throws FileNotFoundException {
        int maxCount = 10;
        int i = 0;
        while (i <= 10) {
            try {
                Thread.sleep(10 * i);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                return new FileOutputStream(storeFile);
            }
            catch (FileNotFoundException e) {
                if (i >= 10 || !e.getMessage().contains("The requested operation cannot be performed on a file with a user-mapped section open")) {
                    throw e;
                }
                ++i;
            }
        }
        return null;
    }

    private static byte[] toByteArray(Document doc) throws CoreException {
        XmlUtil.prettyFormat(doc);
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", ENCODING_UTF_8);
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw new CoreException(CCorePlugin.createStatus(Messages.XmlUtil_InternalErrorSerializing, e));
        }
    }

    public static String replaceLineSeparatorInternal(String string, String lineSeparator) {
        string = string.replace(LINE_SEPARATOR, lineSeparator);
        return string;
    }

    public static void serializeXml(Document doc, IFile file) throws CoreException {
        XmlUtil.prettyFormat(doc);
        try {
            String utfString = new String(XmlUtil.toByteArray(doc), ENCODING_UTF_8);
            String lineSeparator = Util.getLineSeparator(file);
            utfString = XmlUtil.replaceLineSeparatorInternal(utfString, lineSeparator);
            byte[] newContents = utfString.getBytes(ENCODING_UTF_8);
            ByteArrayInputStream input = new ByteArrayInputStream(newContents);
            if (file.exists()) {
                byte[] existingContents = XmlUtil.readFile(file);
                if (!Arrays.equals(existingContents, newContents)) {
                    file.setContents((InputStream)input, 1, null);
                }
            } else {
                file.create((InputStream)input, 1, null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private static byte[] readFile(IFile file) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = file.getContents(true);){
                int nRead;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[4096];
                while ((nRead = is.read(data)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                return buffer.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            return null;
        }
    }

    public static String toString(Document doc) throws CoreException {
        return new String(XmlUtil.toByteArray(doc));
    }
}

