/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.callstack;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.base.IProfilingElement;
import org.eclipse.tracecompass.analysis.profiling.core.base.IProfilingGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStack;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackHostUtils;
import org.eclipse.tracecompass.common.core.math.SaturatedArithmetic;
import org.eclipse.tracecompass.internal.analysis.profiling.core.Activator;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CalledFunctionFactory;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.InstrumentedGroupDescriptor;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.InstrumentedProfilingElement;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class CallStackSeries
implements ISegmentStore<ISegment> {
    public static final int UNKNOWN_TID = -1;
    private final InstrumentedGroupDescriptor fRootGroup;
    private final String fName;
    private final @Nullable IThreadIdResolver fResolver;
    private final CallStackHostUtils.IHostIdResolver fHostResolver;
    private final Map<Integer, IProfilingElement> fRootElements = new HashMap<Integer, IProfilingElement>();

    public CallStackSeries(ITmfStateSystem ss, List<String[]> patternPaths, int symbolKeyLevelIndex, String name, CallStackHostUtils.IHostIdResolver hostResolver, @Nullable IThreadIdResolver threadResolver) {
        int startIndex;
        if (patternPaths.isEmpty()) {
            throw new IllegalArgumentException("State system callstack: the list of paths should not be empty");
        }
        InstrumentedGroupDescriptor prevLevel = new InstrumentedGroupDescriptor(ss, patternPaths.get(startIndex), null, symbolKeyLevelIndex == (startIndex = patternPaths.size() - 1));
        int i = startIndex - 1;
        while (i >= 0) {
            InstrumentedGroupDescriptor level;
            prevLevel = level = new InstrumentedGroupDescriptor(ss, patternPaths.get(i), prevLevel, symbolKeyLevelIndex == i);
            --i;
        }
        this.fRootGroup = prevLevel;
        this.fName = name;
        this.fResolver = threadResolver;
        this.fHostResolver = hostResolver;
    }

    public Collection<IProfilingElement> getRootElements() {
        return InstrumentedProfilingElement.getRootElements(this.fRootGroup, this.fHostResolver, this.fResolver, this.fRootElements);
    }

    public IProfilingGroupDescriptor getRootGroup() {
        return this.fRootGroup;
    }

    public String getName() {
        return this.fName;
    }

    private Collection<IProfilingElement> getLeafElements(IProfilingElement element) {
        if (element.isLeaf()) {
            return Collections.singleton(element);
        }
        ArrayList<IProfilingElement> list = new ArrayList<IProfilingElement>();
        element.getChildren().forEach(e -> {
            boolean bl = list.addAll(this.getLeafElements((IProfilingElement)e));
        });
        return list;
    }

    public int size() {
        return Iterators.size(this.iterator());
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean contains(@Nullable Object o) {
        if (o instanceof ICalledFunction) {
            ICalledFunction seg = (ICalledFunction)o;
            @NonNull Iterable iterable = this.getIntersectingElements(seg.getStart());
            return Iterables.contains((Iterable)iterable, (Object)seg);
        }
        return false;
    }

    public Iterator<ISegment> iterator() {
        ITmfStateSystem stateSystem = this.fRootGroup.getStateSystem();
        long start = stateSystem.getStartTime();
        long end = stateSystem.getCurrentEndTime();
        return this.getIntersectingElements(start, end).iterator();
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException("This segment store can potentially cause OutOfMemoryExceptions");
    }

    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("This segment store can potentially cause OutOfMemoryExceptions");
    }

    public boolean add(ISegment e) {
        throw new UnsupportedOperationException("This segment store does not support adding new segments");
    }

    public boolean containsAll(@Nullable Collection<?> c) {
        ICalledFunction seg;
        if (c == null) {
            return false;
        }
        long minEnd = Long.MAX_VALUE;
        long maxStart = Long.MIN_VALUE;
        for (Object o : c) {
            if (o instanceof ICalledFunction) {
                seg = (ICalledFunction)o;
                minEnd = Math.min(minEnd, seg.getEnd());
                maxStart = Math.max(maxStart, seg.getStart());
                continue;
            }
            return false;
        }
        if (minEnd > maxStart) {
            minEnd = maxStart;
        }
        Iterator<@NonNull ISegment> iterator = this.getIntersectingElements(minEnd, maxStart).iterator();
        int unFound = c.size();
        while (iterator.hasNext() && unFound > 0) {
            seg = iterator.next();
            for (Object o : c) {
                if (!Objects.equals(o, seg)) continue;
                --unFound;
            }
        }
        return unFound == 0;
    }

    public boolean addAll(@Nullable Collection<? extends ISegment> c) {
        throw new UnsupportedOperationException("This segment store does not support adding new segments");
    }

    public void clear() {
        throw new UnsupportedOperationException("This segment store does not support clearing the data");
    }

    private Map<Integer, CallStack> getCallStackQuarks() {
        HashMap<Integer, CallStack> quarkToElement = new HashMap<Integer, CallStack>();
        this.getRootElements().stream().flatMap(e -> this.getLeafElements((IProfilingElement)e).stream()).filter(e -> e instanceof InstrumentedProfilingElement).map(e -> (InstrumentedProfilingElement)e).forEach(e -> e.getStackQuarks().forEach(c -> {
            CallStack callStack = quarkToElement.put((Integer)c, e.getCallStack());
        }));
        return quarkToElement;
    }

    public Iterable<ISegment> getIntersectingElements(long start, long end) {
        return this.getIntersectingElements(start, end, x -> true);
    }

    protected Iterable<ISegment> getIntersectingElements(long start, long end, Predicate<ITmfStateInterval> intervalTest) {
        long endTime;
        ITmfStateSystem stateSystem = this.fRootGroup.getStateSystem();
        long startTime = Math.max(SaturatedArithmetic.add((long)start, (long)-1L), stateSystem.getStartTime());
        if (startTime > (endTime = Math.min(end, stateSystem.getCurrentEndTime()))) {
            return Collections.emptyList();
        }
        Map<Integer, CallStack> quarksToElement = this.getCallStackQuarks();
        try {
            Iterable query2d = stateSystem.query2D(quarksToElement.keySet(), startTime, endTime);
            query2d = Iterables.filter((Iterable)query2d, interval -> !interval.getStateValue().isNull() && intervalTest.test((ITmfStateInterval)interval));
            Function fct = interval -> {
                CallStack callstack = (CallStack)quarksToElement.get(interval.getAttribute());
                if (callstack == null) {
                    throw new NullPointerException("The quark was in that map in the first place, there must be a callstack to go with it!");
                }
                int pid = callstack.getSymbolKeyAt(interval.getStartTime());
                return CalledFunctionFactory.create(interval.getStartTime(), interval.getEndTime() + 1L, Integer.parseInt(stateSystem.getAttributeName(interval.getAttribute())), Objects.requireNonNull(interval.getValue()), pid, null);
            };
            return Iterables.transform((Iterable)query2d, (Function)fct);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            Activator.getInstance().logError("Error getting intersecting elements: StateSystemDisposed");
            return Collections.emptyList();
        }
    }

    public void dispose() {
    }

    private static final class AttributeNameThreadProvider
    implements IThreadIdProvider {
        private final int fTid;

        public AttributeNameThreadProvider(ITmfStateSystem ss, int quark) {
            int tid = -1;
            try {
                String attributeName = ss.getAttributeName(quark);
                tid = Integer.valueOf(attributeName);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                tid = -1;
            }
            this.fTid = tid;
        }

        @Override
        public int getThreadId(long time) {
            return this.fTid;
        }

        @Override
        public boolean variesInTime() {
            return false;
        }
    }

    public static final class AttributeNameThreadResolver
    implements IThreadIdResolver {
        private int fLevel;

        public AttributeNameThreadResolver(int level) {
            this.fLevel = level;
        }

        @Override
        public @Nullable IThreadIdProvider resolve(CallStackHostUtils.IHostIdProvider hostProvider, IProfilingElement element) {
            if (!(element instanceof InstrumentedProfilingElement)) {
                throw new IllegalArgumentException();
            }
            InstrumentedProfilingElement insElement = (InstrumentedProfilingElement)element;
            ArrayList<InstrumentedProfilingElement> elements = new ArrayList<InstrumentedProfilingElement>();
            InstrumentedProfilingElement el = insElement;
            while (el != null) {
                elements.add(el);
                el = el.getParentElement();
            }
            Collections.reverse(elements);
            if (elements.size() <= this.fLevel) {
                return null;
            }
            InstrumentedProfilingElement stackElement = (InstrumentedProfilingElement)elements.get(this.fLevel);
            return new AttributeNameThreadProvider(stackElement.getStateSystem(), stackElement.getQuark());
        }
    }

    private static final class AttributeValueThreadProvider
    implements IThreadIdProvider {
        private final ITmfStateSystem fSs;
        private final int fQuark;
        private @Nullable ITmfStateInterval fInterval;
        private int fLastThreadId = -1;
        private boolean fVariesInTime = true;

        public AttributeValueThreadProvider(ITmfStateSystem ss, int quark) {
            this.fSs = ss;
            this.fQuark = quark;
        }

        @Override
        public int getThreadId(long time) {
            ITmfStateInterval interval = this.fInterval;
            int tid = this.fLastThreadId;
            if (interval != null && (!this.fVariesInTime || interval.intersects(time))) {
                return tid;
            }
            try {
                interval = this.fSs.querySingleState(time, this.fQuark);
                switch (interval.getStateValue().getType()) {
                    case INTEGER: {
                        tid = interval.getStateValue().unboxInt();
                        break;
                    }
                    case LONG: {
                        tid = (int)interval.getStateValue().unboxLong();
                        break;
                    }
                    case STRING: {
                        try {
                            tid = Integer.valueOf(interval.getStateValue().unboxStr());
                        }
                        catch (NumberFormatException numberFormatException) {
                            tid = -1;
                        }
                        break;
                    }
                }
                if (this.fSs.waitUntilBuilt(0L) && interval.intersects(this.fSs.getStartTime()) && interval.intersects(this.fSs.getCurrentEndTime() - 1L)) {
                    this.fVariesInTime = false;
                }
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                interval = null;
                tid = -1;
            }
            this.fInterval = interval;
            this.fLastThreadId = tid;
            return tid;
        }

        @Override
        public boolean variesInTime() {
            return this.fVariesInTime;
        }
    }

    public static final class AttributeValueThreadResolver
    implements IThreadIdResolver {
        private int fLevel;

        public AttributeValueThreadResolver(int level) {
            this.fLevel = level;
        }

        @Override
        public @Nullable IThreadIdProvider resolve(CallStackHostUtils.IHostIdProvider hostProvider, IProfilingElement element) {
            if (!(element instanceof InstrumentedProfilingElement)) {
                throw new IllegalArgumentException();
            }
            InstrumentedProfilingElement insElement = (InstrumentedProfilingElement)element;
            ArrayList<InstrumentedProfilingElement> elements = new ArrayList<InstrumentedProfilingElement>();
            InstrumentedProfilingElement el = insElement;
            while (el != null) {
                elements.add(el);
                el = el.getParentElement();
            }
            Collections.reverse(elements);
            if (elements.size() <= this.fLevel) {
                return null;
            }
            InstrumentedProfilingElement stackElement = (InstrumentedProfilingElement)elements.get(this.fLevel);
            return new AttributeValueThreadProvider(stackElement.getStateSystem(), stackElement.getQuark());
        }
    }

    public static interface IThreadIdProvider {
        public int getThreadId(long var1);

        public boolean variesInTime();
    }

    public static interface IThreadIdResolver {
        public @Nullable IThreadIdProvider resolve(CallStackHostUtils.IHostIdProvider var1, IProfilingElement var2);
    }
}

