/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.context;

import java.nio.ByteBuffer;

public class CtfLocationInfo
implements Comparable<CtfLocationInfo> {
    private final long fTimestamp;
    private final long fIndex;

    public CtfLocationInfo(long ts, long index) {
        this.fTimestamp = ts;
        this.fIndex = index;
    }

    public CtfLocationInfo(ByteBuffer bufferIn) {
        this.fTimestamp = bufferIn.getLong();
        this.fIndex = bufferIn.getLong();
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public long getIndex() {
        return this.fIndex;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.fIndex ^ this.fIndex >>> 32);
        result = 31 * result + (int)(this.fTimestamp ^ this.fTimestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CtfLocationInfo)) {
            return false;
        }
        CtfLocationInfo other = (CtfLocationInfo)obj;
        if (this.fIndex != other.fIndex) {
            return false;
        }
        return this.fTimestamp == other.fTimestamp;
    }

    public String toString() {
        return "Element [" + this.fTimestamp + '/' + this.fIndex + ']';
    }

    @Override
    public int compareTo(CtfLocationInfo other) {
        if (this.fTimestamp > other.getTimestamp()) {
            return 1;
        }
        if (this.fTimestamp < other.getTimestamp()) {
            return -1;
        }
        if (this.fIndex > other.getIndex()) {
            return 1;
        }
        if (this.fIndex < other.getIndex()) {
            return -1;
        }
        return 0;
    }

    public void serialize(ByteBuffer bufferOut) {
        bufferOut.putLong(this.fTimestamp);
        bufferOut.putLong(this.fIndex);
    }
}

