/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.IFlameChartProvider;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.FlameChartDataProvider;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.Messages;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TmfTimeGraphCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class FlameChartDataProviderFactory
implements IDataProviderFactory {
    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        return null;
    }

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace, String secondaryId) {
        ITmfTreeDataProvider<? extends ITmfTreeDataModel> provider = FlameChartDataProviderFactory.create(trace, secondaryId);
        if (provider != null) {
            return provider;
        }
        Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        if (traces.size() > 1) {
            return TmfTimeGraphCompositeDataProvider.create((Collection)traces, (String)"org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.flamechart", (String)secondaryId);
        }
        return null;
    }

    private static @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> create(ITmfTrace trace, String secondaryId) {
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, IFlameChartProvider.class);
        Iterable filteredModules = Iterables.filter((Iterable)modules, m -> m.getId().equals(secondaryId));
        Iterator iterator = filteredModules.iterator();
        if (iterator.hasNext()) {
            IFlameChartProvider module = (IFlameChartProvider)iterator.next();
            if (iterator.hasNext()) {
                return null;
            }
            module.schedule();
            return new FlameChartDataProvider(trace, module, secondaryId);
        }
        return null;
    }

    public Collection<IDataProviderDescriptor> getDescriptors(ITmfTrace trace) {
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, IFlameChartProvider.class);
        ArrayList<IDataProviderDescriptor> descriptors = new ArrayList<IDataProviderDescriptor>();
        HashSet<String> existingModules = new HashSet<String>();
        for (IFlameChartProvider module : modules) {
            IFlameChartProvider analysis = module;
            if (existingModules.contains(analysis.getId())) continue;
            DataProviderDescriptor.Builder builder = new DataProviderDescriptor.Builder();
            builder.setId("org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.flamechart:" + analysis.getId()).setName(Objects.requireNonNull(String.valueOf(Messages.FlameChartDataProvider_Title) + " " + analysis.getName())).setDescription(Objects.requireNonNull(NLS.bind((String)Messages.FlameChartDataProvider_Description, (Object)analysis.getHelpText()))).setProviderType(IDataProviderDescriptor.ProviderType.TIME_GRAPH);
            descriptors.add(builder.build());
            existingModules.add(analysis.getId());
        }
        return descriptors;
    }
}

