/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.symbols;

import java.util.Collection;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;

public final class SymbolProviderUtils {
    private static final Logger LOGGER = TraceCompassLog.getLogger(SymbolProviderUtils.class);

    private SymbolProviderUtils() {
    }

    public static String getSymbolText(Collection<ISymbolProvider> providers, long address) {
        return SymbolProviderUtils.getSymbolText(providers, provider -> provider.getSymbol(address), address);
    }

    public static String getSymbolText(Collection<ISymbolProvider> providers, int pid, long timestamp, long address) {
        return SymbolProviderUtils.getSymbolText(providers, provider -> provider.getSymbol(pid, timestamp, address), address);
    }

    private static String getSymbolText(Collection<ISymbolProvider> providers, Function<ISymbolProvider, @Nullable TmfResolvedSymbol> func, long address) {
        TmfResolvedSymbol resolvedSymbol = null;
        for (ISymbolProvider provider : providers) {
            TmfResolvedSymbol currentSymbol = func.apply(provider);
            if (currentSymbol == null) continue;
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINER, (String)"Symbol found", (Object[])new Object[]{"address", address, "provider", provider, "found symbol", currentSymbol});
            if (resolvedSymbol == null) {
                resolvedSymbol = currentSymbol;
                continue;
            }
            TmfResolvedSymbol tmfResolvedSymbol = resolvedSymbol = Long.compareUnsigned(currentSymbol.getBaseAddress(), resolvedSymbol.getBaseAddress()) >= 0 ? currentSymbol : resolvedSymbol;
        }
        String symbolText = resolvedSymbol != null ? resolvedSymbol.getSymbolName() : "0x" + Long.toHexString(address);
        TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINER, (String)"Symbol returned", (Object[])new Object[]{"address", address, "symbolText", symbolText});
        return symbolText;
    }
}

