/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.google.common.base.Optional;
import java.io.IOException;

public final class GuavaOptionalSerializer
extends StdSerializer<Optional<?>>
implements ContextualSerializer {
    protected final JavaType _referredType;
    protected final BeanProperty _property;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final NameTransformer _unwrapper;
    protected transient PropertySerializerMap _dynamicSerializers;

    public GuavaOptionalSerializer(JavaType optionalType) {
        super(optionalType);
        this._referredType = GuavaOptionalSerializer._valueType(optionalType);
        this._property = null;
        this._valueSerializer = null;
        this._unwrapper = null;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected GuavaOptionalSerializer(GuavaOptionalSerializer base, BeanProperty property, JsonSerializer<?> valueSer, NameTransformer unwrapper) {
        super((StdSerializer)base);
        this._referredType = base._referredType;
        this._dynamicSerializers = base._dynamicSerializers;
        this._property = property;
        this._valueSerializer = valueSer;
        this._unwrapper = unwrapper;
    }

    protected GuavaOptionalSerializer withResolved(BeanProperty prop, JsonSerializer<?> ser, NameTransformer unwrapper) {
        if (this._property == prop && this._valueSerializer == ser && this._unwrapper == unwrapper) {
            return this;
        }
        return new GuavaOptionalSerializer(this, prop, ser, unwrapper);
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            boolean realType;
            boolean bl = realType = !this._referredType.hasRawClass(Object.class);
            if (realType && (provider.isEnabled(MapperFeature.USE_STATIC_TYPING) || this._referredType.isFinal())) {
                return this.withResolved(property, this._findSerializer(provider, this._referredType, this._property), this._unwrapper);
            }
        } else {
            return this.withResolved(property, provider.handlePrimaryContextualization(ser, property), this._unwrapper);
        }
        return this;
    }

    public JsonSerializer<Optional<?>> unwrappingSerializer(NameTransformer transformer) {
        JsonSerializer ser = this._valueSerializer;
        if (ser != null) {
            ser = ser.unwrappingSerializer(transformer);
        }
        NameTransformer unwrapper = this._unwrapper == null ? transformer : NameTransformer.chainedTransformer((NameTransformer)transformer, (NameTransformer)this._unwrapper);
        return this.withResolved(this._property, ser, unwrapper);
    }

    @Deprecated
    public boolean isEmpty(Optional<?> value) {
        return this.isEmpty((SerializerProvider)null, value);
    }

    public boolean isEmpty(SerializerProvider prov, Optional<?> value) {
        return value == null || !value.isPresent();
    }

    public boolean isUnwrappingSerializer() {
        return this._unwrapper != null;
    }

    public void serialize(Optional<?> opt, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (opt.isPresent()) {
            Object value = opt.get();
            JsonSerializer<Object> ser = this._valueSerializer;
            if (ser == null) {
                ser = this._findSerializer(provider, value.getClass());
            }
            ser.serialize(value, gen, provider);
        } else {
            provider.defaultSerializeNull(gen);
        }
    }

    public void serializeWithType(Optional<?> opt, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (opt.isPresent()) {
            Object value = opt.get();
            JsonSerializer<Object> ser = this._valueSerializer;
            if (ser == null) {
                ser = this._findSerializer(provider, value.getClass());
            }
            ser.serializeWithType(value, gen, provider, typeSer);
        } else {
            provider.defaultSerializeNull(gen);
        }
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findSerializer(visitor.getProvider(), this._referredType.getRawClass());
        }
        ser.acceptJsonFormatVisitor(visitor, this._referredType);
    }

    protected static JavaType _valueType(JavaType optionalType) {
        JavaType valueType = optionalType.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.unknownType();
        }
        return valueType;
    }

    protected final JsonSerializer<Object> _findSerializer(SerializerProvider provider, Class<?> type) throws JsonMappingException {
        JsonSerializer ser = this._dynamicSerializers.serializerFor(type);
        if (ser == null) {
            ser = this._findSerializer(provider, type, this._property);
            if (this._unwrapper != null) {
                ser = ser.unwrappingSerializer(this._unwrapper);
            }
            this._dynamicSerializers = this._dynamicSerializers.newWith(type, ser);
        }
        return ser;
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider provider, Class<?> type, BeanProperty prop) throws JsonMappingException {
        return provider.findTypedValueSerializer(type, true, prop);
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider provider, JavaType type, BeanProperty prop) throws JsonMappingException {
        return provider.findTypedValueSerializer(type, true, prop);
    }
}

