/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.index.IIndexMacroContainer;

public class IndexModelUtil {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean bindingHasCElementType(IBinding binding, int[] kinds) {
        int[] nArray = kinds;
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            int kind = nArray[n2];
            switch (kind) {
                case 67: {
                    if (!(binding instanceof ICompositeType) || ((ICompositeType)binding).getKey() != 1) break;
                    return true;
                }
                case 69: {
                    if (!(binding instanceof ICompositeType) || ((ICompositeType)binding).getKey() != 2) break;
                    return true;
                }
                case 65: {
                    if (!(binding instanceof ICompositeType) || ((ICompositeType)binding).getKey() != 3) break;
                    return true;
                }
                case 61: {
                    if (!(binding instanceof ICPPNamespace) && !(binding instanceof ICPPNamespaceAlias)) break;
                    return true;
                }
                case 63: {
                    if (!(binding instanceof IEnumeration)) break;
                    return true;
                }
                case 80: {
                    if (!(binding instanceof ITypedef)) break;
                    return true;
                }
                case 74: {
                    if (!(binding instanceof IFunction)) break;
                    return true;
                }
                case 76: {
                    if (!(binding instanceof IVariable)) break;
                    return true;
                }
                case 81: {
                    if (!(binding instanceof IEnumerator)) break;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static int getElementType(IBinding binding) {
        int elementType = Integer.MIN_VALUE;
        if (binding instanceof ICompositeType) {
            ICompositeType classType = (ICompositeType)binding;
            switch (classType.getKey()) {
                case 3: {
                    elementType = 65;
                    break;
                }
                case 1: {
                    elementType = 67;
                    break;
                }
                case 2: {
                    elementType = 69;
                }
            }
        }
        if (binding instanceof ICPPNamespace || binding instanceof ICPPNamespaceAlias) {
            elementType = 61;
        }
        if (binding instanceof IEnumeration) {
            elementType = 63;
        }
        if (binding instanceof ITypedef) {
            elementType = 80;
        }
        if (binding instanceof IFunction) {
            elementType = 74;
        }
        if (binding instanceof IVariable) {
            IScope scope = null;
            try {
                scope = binding.getScope();
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
            elementType = scope != null && scope.getKind() == EScopeKind.eLocal ? 78 : 76;
        }
        if (binding instanceof IEnumerator) {
            elementType = 81;
        }
        if (binding instanceof IMacroBinding || binding instanceof IIndexMacroContainer) {
            elementType = 79;
        }
        if (binding instanceof IParameter) {
            elementType = 78;
        }
        return elementType;
    }

    public static String[] extractParameterTypes(IFunction function) throws DOMException {
        IParameter[] params = function.getParameters();
        boolean vararg = function.takesVarArgs();
        int paramCount = params.length + (vararg ? 1 : 0);
        String[] parameterTypes = new String[paramCount];
        int i = 0;
        while (i < params.length) {
            IParameter param = params[i];
            parameterTypes[i] = ASTTypeUtil.getType(param.getType(), false);
            ++i;
        }
        if (vararg) {
            parameterTypes[paramCount - 1] = "...";
        }
        if (parameterTypes.length == 1 && parameterTypes[0].equals("void")) {
            return EMPTY_STRING_ARRAY;
        }
        return parameterTypes;
    }

    public static String extractReturnType(IFunction function) throws DOMException {
        return ASTTypeUtil.getType(function.getType().getReturnType(), false);
    }
}

