/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;

public final class StateSystemBuilderUtils {
    private StateSystemBuilderUtils() {
    }

    public static void incrementAttributeLong(ITmfStateSystemBuilder ssb, long t, int attributeQuark, long increment) throws StateValueTypeException {
        @Nullable Object stateValue = ssb.queryOngoing(attributeQuark);
        long prevValue = 0L;
        if (stateValue != null && stateValue instanceof Long) {
            prevValue = (Long)stateValue;
        }
        ssb.modifyAttribute(t, prevValue + increment, attributeQuark);
    }

    public static void incrementAttributeInt(ITmfStateSystemBuilder ssb, long t, int attributeQuark, int increment) throws StateValueTypeException {
        @Nullable Object stateValue = ssb.queryOngoing(attributeQuark);
        int prevValue = 0;
        if (stateValue != null && stateValue instanceof Integer) {
            prevValue = (Integer)stateValue;
        }
        ssb.modifyAttribute(t, prevValue + increment, attributeQuark);
    }

    public static void incrementAttributeDouble(ITmfStateSystemBuilder ssb, long t, int attributeQuark, double increment) throws StateValueTypeException {
        @Nullable Object stateValue = ssb.queryOngoing(attributeQuark);
        double prevValue = 0.0;
        if (stateValue instanceof Double) {
            prevValue = (Double)stateValue;
        }
        ssb.modifyAttribute(t, prevValue + increment, attributeQuark);
    }
}

