/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfTraceAdapterManager {
    private static Multimap<String, IAdapterFactory> fFactoriesById = HashMultimap.create();
    private static Multimap<Class<? extends ITmfTrace>, IAdapterFactory> fFactoriesByClass = HashMultimap.create();

    public static void registerFactory(IAdapterFactory factory, String traceTypeId) {
        fFactoriesById.put((Object)traceTypeId, (Object)factory);
    }

    public static void registerFactory(IAdapterFactory factory, Class<? extends ITmfTrace> traceClass) {
        fFactoriesByClass.put(traceClass, (Object)factory);
    }

    public static void unregisterFactory(IAdapterFactory factory) {
        fFactoriesById.values().remove(factory);
        fFactoriesByClass.values().remove(factory);
    }

    public static <T> List<T> getAdapters(ITmfTrace trace, Class<T> adapterType) {
        Object adapter;
        Collection factoriesById = fFactoriesById.get((Object)trace.getTraceTypeId());
        Collection entries = fFactoriesByClass.entries();
        ArrayList<Object> adapters = new ArrayList<Object>(factoriesById.size() + entries.size());
        for (IAdapterFactory factory : factoriesById) {
            adapter = factory.getAdapter((Object)trace, adapterType);
            if (adapter == null) continue;
            adapters.add(adapter);
        }
        for (Map.Entry entry : entries) {
            if (!((Class)entry.getKey()).isInstance(trace) || (adapter = ((IAdapterFactory)entry.getValue()).getAdapter((Object)trace, adapterType)) == null) continue;
            adapters.add(adapter);
        }
        return adapters;
    }
}

