/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.coff.PE64;
import org.eclipse.cdt.utils.coff.parser.PEBinaryArchive64;
import org.eclipse.cdt.utils.coff.parser.PEBinaryExecutable64;
import org.eclipse.cdt.utils.coff.parser.PEBinaryObject64;
import org.eclipse.cdt.utils.coff.parser.PEBinaryShared64;
import org.eclipse.core.runtime.IPath;

public class PEParser64
extends AbstractCExtension
implements IBinaryParser {
    @Override
    public IBinaryParser.IBinaryFile getBinary(IPath path) throws IOException {
        return this.getBinary(null, path);
    }

    @Override
    public IBinaryParser.IBinaryFile getBinary(byte[] hints, IPath path) throws IOException {
        if (path == null) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.nullPath"));
        }
        IBinaryParser.IBinaryFile binary = null;
        try {
            PE64.Attribute attribute = null;
            if (hints != null && hints.length > 0) {
                try {
                    attribute = PE64.getAttribute(hints);
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            if (attribute == null) {
                attribute = PE64.getAttribute(path.toOSString());
            }
            if (attribute != null) {
                switch (attribute.getType()) {
                    case 1: {
                        binary = this.createBinaryExecutable(path);
                        break;
                    }
                    case 2: {
                        binary = this.createBinaryShared(path);
                        break;
                    }
                    case 3: {
                        binary = this.createBinaryObject(path);
                        break;
                    }
                    case 4: {
                        binary = this.createBinaryCore(path);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            binary = this.createBinaryArchive(path);
        }
        return binary;
    }

    @Override
    public String getFormat() {
        return "PE";
    }

    @Override
    public boolean isBinary(byte[] array, IPath path) {
        boolean isBin;
        boolean bl = isBin = PE64.isExeHeader(array) || AR.isARHeader(array);
        if (!isBin && array.length > 1) {
            int f_magic = (array[1] & 0xFF) << 8 | array[0] & 0xFF;
            isBin = PE64.isValidMachine(f_magic);
        }
        return isBin;
    }

    @Override
    public int getHintBufferSize() {
        return 512;
    }

    protected IBinaryParser.IBinaryExecutable createBinaryExecutable(IPath path) {
        return new PEBinaryExecutable64(this, path);
    }

    protected IBinaryParser.IBinaryObject createBinaryCore(IPath path) {
        return new PEBinaryObject64((IBinaryParser)this, path, 16);
    }

    protected IBinaryParser.IBinaryObject createBinaryObject(IPath path) {
        return new PEBinaryObject64((IBinaryParser)this, path, 1);
    }

    protected IBinaryParser.IBinaryShared createBinaryShared(IPath path) {
        return new PEBinaryShared64(this, path);
    }

    protected IBinaryParser.IBinaryArchive createBinaryArchive(IPath path) throws IOException {
        return new PEBinaryArchive64(this, path);
    }
}

