/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator;

import java.io.IOException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.event.BinaryFTraceEvent;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceCPUDataPage;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFileCPU;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceHeaderInfo;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceCPUPageIterator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceIteratorHelper;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceResponse;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;

public class BinaryFTraceCPUSectionIterator
implements AutoCloseable {
    private final @Nullable BinaryFTraceHeaderInfo headerInfo;
    private @Nullable BinaryFTraceCPUPageIterator fCurrPageIterator;
    private BinaryFTraceCPUDataPage fHeadPage;

    public BinaryFTraceCPUSectionIterator(BinaryFTraceFileCPU cpu, BinaryFTraceHeaderInfo headerInfo) throws IOException {
        this.headerInfo = headerInfo;
        if (!cpu.getPages().isEmpty()) {
            this.fHeadPage = cpu.getPages().get(0);
            this.fCurrPageIterator = BinaryFTraceIteratorHelper.getPageIterator(this.fHeadPage, headerInfo);
        } else {
            this.fHeadPage = null;
            this.fCurrPageIterator = null;
        }
    }

    public BinaryFTraceResponse readNextEvent() {
        BinaryFTraceCPUPageIterator iter = this.fCurrPageIterator;
        BinaryFTraceResponse response = BinaryFTraceResponse.ERROR;
        if (iter != null) {
            try {
                response = iter.readNextEvent();
                if (response == BinaryFTraceResponse.FINISH) {
                    if (iter.getPage().getNextPage() != null) {
                        iter.close();
                        iter = BinaryFTraceIteratorHelper.getPageIterator(iter.getPage().getNextPage(), this.headerInfo);
                        if (iter != null) {
                            response = iter.readNextEvent();
                        }
                    } else {
                        response = BinaryFTraceResponse.FINISH;
                    }
                }
            }
            catch (IOException ex) {
                Activator.getInstance().logInfo("An error occured while reading the next trace event", (Throwable)ex);
            }
            this.fCurrPageIterator = iter;
        }
        return response;
    }

    public long getCurrentTimeStamp() {
        BinaryFTraceCPUPageIterator iter = this.fCurrPageIterator;
        if (iter != null) {
            return iter.getCurrentTimeStamp();
        }
        return TmfTimestamp.BIG_BANG.toNanos();
    }

    @Override
    public void close() throws IOException {
        BinaryFTraceCPUPageIterator iter = this.fCurrPageIterator;
        if (iter != null) {
            iter.close();
        }
    }

    public @Nullable BinaryFTraceEvent getCurrentEvent() throws IOException {
        BinaryFTraceCPUPageIterator iter = this.fCurrPageIterator;
        if (iter != null) {
            return iter.getCurrentEvent();
        }
        return null;
    }

    public boolean seek(long timestamp) throws IOException {
        this.resetIterator();
        BinaryFTraceCPUDataPage currPage = this.fHeadPage;
        boolean ret = false;
        if (currPage != null) {
            BinaryFTraceCPUPageIterator iter;
            BinaryFTraceCPUDataPage nextPage = currPage.getNextPage();
            if (timestamp > currPage.getTimeStamp()) {
                while (nextPage != null && timestamp >= nextPage.getTimeStamp()) {
                    currPage = nextPage;
                    nextPage = currPage.getNextPage();
                }
            }
            if ((iter = BinaryFTraceIteratorHelper.getPageIterator(currPage, this.headerInfo)) != null) {
                ret = iter.seek(timestamp);
            }
            if (!ret && nextPage != null && (iter = BinaryFTraceIteratorHelper.getPageIterator(nextPage, this.headerInfo)) != null) {
                ret = iter.seek(timestamp);
            }
            this.fCurrPageIterator = iter;
        }
        return ret;
    }

    private void resetIterator() throws IOException {
        BinaryFTraceCPUPageIterator iter = this.fCurrPageIterator;
        if (iter != null) {
            iter.close();
        }
        this.fCurrPageIterator = BinaryFTraceIteratorHelper.getPageIterator(this.fHeadPage, this.headerInfo);
    }
}

